/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.utility;

import io.github.cruisoring.repository.Repository;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateTimeHelper {
    public static String DefaultDateFormat = "yyyy-MM-dd";
    public static String DefaultDateTimeFormat = "yyyy-MM-dd HH:mm:ss";
    static Repository<String, DateTimeFormatter> dateFormatRepository = new Repository<String, DateTimeFormatter>(DateTimeFormatter::ofPattern);

    public static String asString(LocalDate localDate, String ... formats) {
        String format = formats == null || formats.length == 0 ? DefaultDateFormat : formats[0];
        DateTimeFormatter formatter = dateFormatRepository.get(format, null);
        return formatter == null ? null : formatter.format(localDate);
    }

    public static String asString(Date date, String ... formats) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return DateTimeHelper.asString(localDate, formats);
    }

    public static String asString(LocalDateTime localDateTime, String ... formats) {
        String format = formats == null || formats.length == 0 ? DefaultDateFormat : formats[0];
        DateTimeFormatter formatter = dateFormatRepository.get(format, null);
        return formatter == null ? null : formatter.format(localDateTime);
    }
}

