/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.utility;

import io.github.cruisoring.Asserts;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OrdinalComparator<T>
implements Comparator<T> {
    final Map<T, Integer> orders = new HashMap<T, Integer>();
    final List<T> orderedKeys = new ArrayList<T>();

    public OrdinalComparator(T ... options) {
        for (T option : options) {
            this.putIfAbsent(Asserts.checkNoneNulls(option, new Object[0]), this.orders.size() + 1);
        }
    }

    public void putIfAbsent(T key) {
        if (!this.orders.containsKey(key)) {
            this.orders.put(key, this.orders.size() + 1);
            this.orderedKeys.add(key);
        }
    }

    Integer putIfAbsent(T key, Integer order) {
        if (!this.orders.containsKey(key)) {
            this.orders.put(key, order);
            this.orderedKeys.add(key);
            return order;
        }
        return this.orders.get(key);
    }

    @Override
    public int compare(T o1, T o2) {
        Integer order2 = this.putIfAbsent(o2, this.orders.size() + 1);
        Integer order1 = this.putIfAbsent(o1, this.orders.size() + 1);
        return order1.compareTo(order2);
    }

    public String toString() {
        String string = this.orderedKeys.stream().map(k -> k.toString()).collect(Collectors.joining(","));
        return string;
    }
}

