/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.utility;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.logger.Logger;
import io.github.cruisoring.utility.StackTraceHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

public class ResourceHelper {
    public static final String[] resourcePaths;
    public static String MAVEN_TARGET;
    public static String MAVEN_TARGET_CLASSES;
    public static String MAVEN_TARGET_TEST_CLASSES;
    public static String MAVEN_MAIN_RESOURCES;
    public static String MAVEN_TEST_RESOURCES;

    private static String[] getResourcePaths(String ... ignoreables) {
        ArrayList<String> classPaths = new ArrayList<String>();
        List<String> classNames = StackTraceHelper.getFilteredCallers(ignoreables);
        for (int i = 0; i < classNames.size(); ++i) {
            try {
                String className = classNames.get(i);
                Class<?> clazz = Class.forName(className);
                String classPath = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
                if (classPath.endsWith(MAVEN_TARGET_CLASSES)) {
                    classPath = classPath.replace(MAVEN_TARGET_CLASSES, MAVEN_MAIN_RESOURCES);
                } else {
                    if (!classPath.endsWith(MAVEN_TARGET_TEST_CLASSES)) continue;
                    classPath = classPath.replace(MAVEN_TARGET_TEST_CLASSES, MAVEN_TEST_RESOURCES);
                }
                if (classPaths.contains(classPath)) continue;
                classPaths.add(classPath);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        Collections.reverse(classPaths);
        String[] result = classPaths.toArray(new String[0]);
        return result;
    }

    public static Class[] getClasses(String packageName) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (File directory : dirs) {
            classes.addAll(ResourceHelper.findClasses(directory, packageName));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static List<Class> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList<Class> classes = new ArrayList<Class>();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(ResourceHelper.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }

    public static Boolean isResourceAvailable(String resourceFilename) {
        URL url = ResourceHelper.class.getClassLoader().getResource(resourceFilename);
        return url != null;
    }

    public static String getTextFromResourceFile(String resourceFilename) {
        Asserts.checkNotNull(resourceFilename, "no resourceFilename defined.", new Object[0]);
        String text = null;
        try {
            Path path = Paths.get(resourceFilename, new String[0]);
            if (path.isAbsolute()) {
                byte[] bytes = Files.readAllBytes(path);
                return new String(bytes);
            }
            URL url = ResourceHelper.class.getClassLoader().getResource(resourceFilename);
            if (url == null) {
                return null;
            }
            URI uri = url.toURI();
            byte[] bytes = Files.readAllBytes(Paths.get(uri));
            text = new String(bytes);
        }
        catch (Exception e) {
            Logger.W(e.getMessage(), new Object[0]);
        }
        return text;
    }

    public static Map<String, Properties> getAllProperties(String resourcePackagename, Map<String, Properties> result) {
        File[] propertiesFiles;
        ClassLoader classLoader;
        String path;
        File file;
        if (result == null) {
            result = new HashMap<String, Properties>();
        }
        if (!(file = new File(path = (classLoader = ResourceHelper.class.getClassLoader()).getResource(resourcePackagename).getPath())).exists()) {
            Logger.W("Failed to find: %s", resourcePackagename);
            return null;
        }
        for (File f : propertiesFiles = new File(path).listFiles()) {
            if (f.isFile()) {
                ResourceHelper.addFile(f, result);
                continue;
            }
            if (!f.isDirectory()) continue;
            ResourceHelper.addDirectory(f, result);
        }
        return result;
    }

    protected static void addDirectory(File file, Map<String, Properties> result) {
        File[] files;
        for (File f : files = new File(file.getPath()).listFiles()) {
            if (f.isFile()) {
                ResourceHelper.addFile(f, result);
                continue;
            }
            if (!f.isDirectory()) continue;
            ResourceHelper.addDirectory(f, result);
        }
    }

    protected static void addFile(File file, Map<String, Properties> result) {
        String propertiesName = file.getName();
        propertiesName = propertiesName.substring(0, propertiesName.indexOf("."));
        Properties properties = new Properties();
        try {
            properties.load(new FileReader(file));
        }
        catch (IOException e) {
            Logger.W(e.getMessage(), new Object[0]);
            return;
        }
        result.put(propertiesName, properties);
    }

    public static File getResourceFile(String filename, String ... folderNames) {
        Asserts.assertAllNotNull(filename, new String[0]);
        String folderPath = folderNames == null ? "" : String.join((CharSequence)"/", folderNames);
        for (String path : resourcePaths) {
            File resourceFolder = new File(path, folderPath);
            File file = new File(resourceFolder, filename);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public static Path getResourcePath(String filename, String ... folderNames) {
        Asserts.assertAllNotNull(filename, new String[0]);
        String folderPath = folderNames == null ? "" : String.join((CharSequence)"/", folderNames);
        for (String path : resourcePaths) {
            File resourceFolder = new File(path, folderPath);
            File file = new File(resourceFolder, filename);
            if (!file.exists()) continue;
            return file.toPath();
        }
        String error = String.format("Failed to locate %s in folder of %s from %s", filename, folderPath, String.join((CharSequence)",", resourcePaths));
        throw new RuntimeException(error);
    }

    public static Path getAbsoluteFilePath(String filename, String ... folderNames) {
        Asserts.assertAllNotNull(filename, new String[0]);
        String folderPath = folderNames == null ? "" : String.join((CharSequence)"/", folderNames);
        File folder = new File(resourcePaths[0], folderPath);
        File file = new File(folder, filename);
        return file.toPath();
    }

    public static String getTextFromResourceFile(String resourceFilename, String ... folders) {
        Path path = ResourceHelper.getResourcePath(resourceFilename, folders);
        if (path == null) {
            return null;
        }
        try {
            byte[] encoded = Files.readAllBytes(path);
            String text = new String(encoded, Charset.defaultCharset());
            return text;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String saveTextToTargetFile(String text, String filepath) {
        Asserts.assertAllNotNull(text, filepath);
        try {
            File savedFile;
            if (Paths.get(filepath, new String[0]).isAbsolute()) {
                savedFile = new File(filepath);
            } else {
                savedFile = new File(filepath = filepath.startsWith("target") ? filepath : "target\\" + filepath).getAbsoluteFile();
                File directory = savedFile.getParentFile();
                if (!directory.exists()) {
                    directory.mkdirs();
                }
            }
            Files.write(savedFile.toPath(), text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return savedFile.getAbsolutePath();
        }
        catch (IOException e) {
            String error = e.toString();
            return error;
        }
    }

    public static Properties asProperties(Properties properties, Map<?, ?> ... maps) {
        if (properties == null) {
            properties = new Properties(){

                @Override
                public synchronized Enumeration<Object> keys() {
                    return Collections.enumeration(new TreeSet<Object>(super.keySet()));
                }
            };
        }
        if (maps == null) {
            return properties;
        }
        for (Map<?, ?> map : maps) {
            properties.putAll(map);
        }
        return properties;
    }

    public static String saveProperties(Properties properties, String filePath) {
        Asserts.assertAllNotNull(properties, filePath);
        return ResourceHelper.saveProperties(properties, new File(filePath));
    }

    public static String saveProperties(Properties properties, File file) {
        Asserts.assertAllNotNull(properties, file);
        FileOutputStream fr = null;
        try {
            fr = new FileOutputStream(file);
            try {
                properties.store(fr, null);
                fr.close();
                Logger.D("Properties with %d values is saved as %s", properties.size(), file);
                return file.getAbsolutePath();
            }
            catch (IOException e) {
                Logger.W("failed to save to %s: %s", file, e.getMessage());
                return null;
            }
        }
        catch (FileNotFoundException e) {
            Logger.W("failed to locate the file: %s", file);
            return null;
        }
    }

    static {
        MAVEN_TARGET = "target";
        MAVEN_TARGET_CLASSES = "target/classes/";
        MAVEN_TARGET_TEST_CLASSES = "target/test-classes/";
        MAVEN_MAIN_RESOURCES = "src/main/resources/";
        MAVEN_TEST_RESOURCES = "src/test/resources/";
        resourcePaths = ResourceHelper.getResourcePaths("sun.reflect", "java.lang");
    }
}

