/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.utility;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.throwables.SupplierThrowable;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;

public class SetHelper {
    public static Supplier<Set> defaultSetSupplier = HashSet::new;

    public static <T> Set<T> asSet(SupplierThrowable<Set<T>> setSupplier, T ... elements) {
        Set set = setSupplier == null ? defaultSetSupplier.get() : (Set)setSupplier.orElse(null).get();
        Asserts.checkNotNull(set, "Failed to get the instance of Set<T>", new Object[0]);
        return SetHelper.fillSet(set, elements);
    }

    public static <T> Set<T> asSet(T ... elements) {
        return SetHelper.asSet(null, elements);
    }

    static <T> Set<T> fillSet(Set<T> set, T ... elements) {
        if (elements == null) {
            set.add(null);
        } else {
            for (int i = 0; i < elements.length; ++i) {
                set.add(elements[i]);
            }
        }
        return set;
    }

    public static <T> Set<T> asHashSet(T ... elements) {
        return SetHelper.fillSet(new HashSet(), elements);
    }

    public static <T> Set<T> asTreeSet(T ... elements) {
        Asserts.assertAllNotNull(elements, new Object[0][]);
        return SetHelper.fillSet(new TreeSet(), elements);
    }

    public static <T> Set<T> asLinkedHashSet(T ... elements) {
        return SetHelper.fillSet(new LinkedHashSet(), elements);
    }

    public static <T> Set<T> union(Set<T> setA, Set<T> setB, Set<T> ... others) {
        Set set = defaultSetSupplier.get();
        Asserts.checkNoneNulls(set, setA, setB, others).addAll(setA);
        set.addAll(setB);
        for (int i = 0; i < others.length; ++i) {
            set.addAll(others[i]);
        }
        return set;
    }

    public static <T> Set<T> intersection(Set<T> setA, Set<T> setB, Set<T> ... others) {
        Set intersection = defaultSetSupplier.get();
        Asserts.checkNoneNulls(intersection, setA, setB, others).addAll(setA);
        intersection.retainAll(setB);
        for (int i = 0; i < others.length; ++i) {
            if (intersection.isEmpty()) {
                return intersection;
            }
            intersection.retainAll(others[i]);
        }
        return intersection;
    }

    public static <T> Set<T> difference(Set<T> setA, Set<T> setB) {
        Set set = defaultSetSupplier.get();
        Asserts.checkNoneNulls(set, setA, setB).addAll(setA);
        set.removeAll(setB);
        return set;
    }

    public static <T> Set<T> symmetricDifference(Set<T> setA, Set<T> setB) {
        Set set = defaultSetSupplier.get();
        Asserts.checkNoneNulls(set, setA, setB).addAll(setA);
        for (T element : setB) {
            if (set.add(element)) continue;
            set.remove(element);
        }
        return set;
    }
}

