/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.Functions;
import io.github.cruisoring.throwables.BiConsumerThrowable;
import io.github.cruisoring.throwables.FunctionThrowable;
import io.github.cruisoring.throwables.RunnableThrowable;
import io.github.cruisoring.throwables.SupplierThrowable;
import io.github.cruisoring.utility.SimpleTypedList;
import java.util.List;
import java.util.function.Function;

public class Lazy<T>
implements AutoCloseable {
    final SupplierThrowable<T> supplier;
    final BiConsumerThrowable<T, T> actionOnChanges;
    protected List<AutoCloseable> dependencies;
    private boolean isInitialized = false;
    private T value = null;
    private boolean isClosed = false;

    public Lazy(SupplierThrowable<T> supplier) {
        this.supplier = Asserts.checkNotNull(supplier, "The supplier is mandatory");
        this.actionOnChanges = null;
    }

    public Lazy(SupplierThrowable<T> supplier, BiConsumerThrowable<T, T> actionOnChanges) {
        this.supplier = Asserts.checkNotNull(supplier, "The supplier is mandatory");
        this.actionOnChanges = actionOnChanges;
    }

    public <U> Lazy<U> create(FunctionThrowable<T, U> function) {
        Lazy<Object> dependency = new Lazy<Object>(() -> function.apply(this.getValue()));
        if (this.dependencies == null) {
            this.dependencies = new SimpleTypedList<AutoCloseable>(new AutoCloseable[0]);
        }
        this.dependencies.add(dependency);
        return dependency;
    }

    public <U> Lazy<U> create(FunctionThrowable<T, U> function, BiConsumerThrowable<U, U> actionOnChanges) {
        Lazy<Object> dependency = new Lazy<Object>(() -> function.apply(this.getValue()), actionOnChanges);
        if (this.dependencies == null) {
            this.dependencies = new SimpleTypedList<AutoCloseable>(new AutoCloseable[0]);
        }
        this.dependencies.add(dependency);
        return dependency;
    }

    public boolean isValueInitialized() {
        return this.isInitialized;
    }

    public T getValue() {
        if (!this.isInitialized) {
            T oldValue = this.value;
            this.value = this.supplier.withHandler(new Function[0]).get();
            this.isInitialized = true;
            this.isClosed = false;
            if (this.actionOnChanges != null) {
                this.actionOnChanges.withHandler(Functions::logAndReturnsNull).accept(oldValue, this.value);
            }
        }
        return this.value;
    }

    public void closing() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.dependencies != null) {
            for (int i = this.dependencies.size() - 1; i >= 0; --i) {
                AutoCloseable child = this.dependencies.get(i);
                if (child == null) continue;
                RunnableThrowable runnableThrowable = child::close;
                runnableThrowable.withHandler(Functions::logAndReturnsNull).run();
            }
            this.dependencies.clear();
        }
        if (this.isInitialized) {
            this.isInitialized = false;
            if (this.value instanceof AutoCloseable) {
                Functions.tryRun(((AutoCloseable)this.value)::close);
            }
            T currentValue = this.value;
            this.value = null;
            if (this.actionOnChanges != null) {
                this.actionOnChanges.withHandler(Functions::logAndReturnsNull).accept(currentValue, null);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.closing();
    }
}

