/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.Functions;
import io.github.cruisoring.logger.LogLevel;
import io.github.cruisoring.logger.Logger;
import io.github.cruisoring.throwables.ConsumerThrowable;
import io.github.cruisoring.throwables.RunnableThrowable;
import io.github.cruisoring.utility.SimpleTypedList;
import io.github.cruisoring.utility.StackTraceHelper;
import java.time.LocalDateTime;
import java.util.List;
import java.util.function.Supplier;

public class Revokable<T>
implements AutoCloseable {
    static final String[] calledKeywords = new String[]{Revokable.class.getSimpleName() + ".java", Logger.class.getSimpleName() + ".java"};
    public static LogLevel DefaultLogLevel = LogLevel.verbose;
    public static boolean DefaultCloseNewSetting = true;
    static final List<Revokable> All = new SimpleTypedList<Revokable>(new Revokable[0]);
    final LocalDateTime timeStamp;
    final String label;
    final T originalSetting;
    T newSetting;
    final RunnableThrowable revoker;
    private boolean isClosed = false;

    public static <T> Revokable register(Supplier<T> getter, ConsumerThrowable<T> setter, T newSetting) {
        Revokable<T> revokable = new Revokable<T>(getter, setter, newSetting);
        if (revokable.revoker != null) {
            All.add(revokable);
        }
        return revokable;
    }

    public static Revokable register(RunnableThrowable runnableThrowable) {
        Revokable revokable = new Revokable(runnableThrowable);
        All.add(revokable);
        return revokable;
    }

    public static void revokeAll() {
        for (int i = All.size() - 1; i >= 0; --i) {
            Revokable revokable = All.get(i);
            if (revokable != null && !revokable.isClosed) {
                revokable.close();
            }
            All.remove(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Revokable(Supplier<T> getter, ConsumerThrowable<T> setter, T newSetting) {
        Asserts.assertAllNotNull(getter, setter);
        this.timeStamp = LocalDateTime.now();
        this.label = StackTraceHelper.getCallerLabel(null, calledKeywords);
        this.originalSetting = getter.get();
        this.newSetting = newSetting;
        boolean setSuccessfully = false;
        try {
            setter.accept(newSetting);
            setSuccessfully = true;
            this.revoker = setSuccessfully ? () -> setter.accept(this.originalSetting) : null;
        }
        catch (Exception e) {
            try {
                Logger.getDefault().log(DefaultLogLevel, "Failed to update setting: %s", e.getMessage());
                this.revoker = setSuccessfully ? () -> setter.accept(this.originalSetting) : null;
            }
            catch (Throwable throwable) {
                this.revoker = setSuccessfully ? () -> setter.accept(this.originalSetting) : null;
                throw throwable;
            }
        }
    }

    public Revokable(RunnableThrowable runnableThrowable) {
        Asserts.assertAllNotNull(runnableThrowable, new RunnableThrowable[0]);
        this.timeStamp = LocalDateTime.now();
        this.label = StackTraceHelper.getCallerLabel(null, calledKeywords);
        this.originalSetting = null;
        this.newSetting = null;
        this.revoker = runnableThrowable;
    }

    public LocalDateTime getTimeStamp() {
        return this.timeStamp;
    }

    public T getOriginalSetting() {
        return this.originalSetting;
    }

    public T getNewSetting() {
        return this.newSetting;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void closing(boolean closeNew) {
        if (!this.isClosed) {
            this.isClosed = true;
            if (this.revoker != null) {
                this.revoker.withHandler(Functions::logAndReturnsNull).run();
            }
            if (this.originalSetting == null && this.newSetting == null) {
                Logger.getDefault().log(DefaultLogLevel, "%s is reverted.", this.label);
            } else {
                Logger.getDefault().log(DefaultLogLevel, "%s is reverted from %s back to %s.", this.label, this.newSetting, this.originalSetting);
            }
            if (this.newSetting instanceof AutoCloseable) {
                if (closeNew) {
                    RunnableThrowable runnableThrowable = ((AutoCloseable)this.newSetting)::close;
                    runnableThrowable.withHandler(Functions::logAndReturnsNull).run();
                }
                this.newSetting = null;
            }
        }
    }

    @Override
    public void close() {
        this.closing(DefaultCloseNewSetting);
    }
}

