/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.logger;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.logger.LogLevel;
import io.github.cruisoring.logger.Logger;
import io.github.cruisoring.logger.Measurement;
import io.github.cruisoring.throwables.RunnableThrowable;
import io.github.cruisoring.throwables.SupplierThrowable;
import io.github.cruisoring.utility.StackTraceHelper;
import io.github.cruisoring.utility.StringHelper;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public interface ILogger {
    public void save(String var1);

    public LogLevel getMinLevel();

    public boolean canLog(LogLevel var1);

    public String getMessage(LogLevel var1, String var2, Object ... var3);

    default public <R> R measure(Measurement.Moment startMoment, R value, LogLevel ... levels) {
        Asserts.assertAllNotNull(startMoment, new Measurement.Moment[0]);
        LogLevel level = levels == null || levels.length == 0 ? Logger.DefaultMeasureLogLevel : levels[0];
        long elapsedMills = System.currentTimeMillis() - startMoment.createdAt;
        Measurement.save(startMoment.label, Measurement.DefaultColumns.createRow(startMoment.createdAt, elapsedMills));
        this.log(level, "%s costs %s.", startMoment.label, Duration.ofMillis(elapsedMills));
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <R> R measure(Measurement.Moment startMoment, SupplierThrowable<R> supplier, LogLevel ... levels) {
        R r;
        Asserts.assertAllNotNull(startMoment, supplier);
        LogLevel level = levels == null || levels.length == 0 ? Logger.DefaultMeasureLogLevel : levels[0];
        Exception e = null;
        long elapsedMills = 0L;
        try {
            R result = supplier.get();
            elapsedMills = System.currentTimeMillis() - startMoment.createdAt;
            Measurement.save(startMoment.label, Measurement.DefaultColumns.createRow(startMoment.createdAt, elapsedMills));
            r = result;
        }
        catch (Exception ex) {
            R r2;
            try {
                elapsedMills = System.currentTimeMillis() - startMoment.createdAt;
                e = ex;
                r2 = null;
            }
            catch (Throwable throwable) {
                this.log(level, "%s costs %s%s.", startMoment.label, Duration.ofMillis(elapsedMills), e == null ? "" : " with " + e.getClass().getSimpleName());
                throw throwable;
            }
            this.log(level, "%s costs %s%s.", startMoment.label, Duration.ofMillis(elapsedMills), e == null ? "" : " with " + e.getClass().getSimpleName());
            return r2;
        }
        this.log(level, "%s costs %s%s.", startMoment.label, Duration.ofMillis(elapsedMills), e == null ? "" : " with " + e.getClass().getSimpleName());
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public ILogger measure(Measurement.Moment startMoment, RunnableThrowable runnable, LogLevel ... levels) {
        Asserts.assertAllNotNull(startMoment, runnable);
        LogLevel level = levels == null || levels.length == 0 ? Logger.DefaultMeasureLogLevel : levels[0];
        Exception e = null;
        long elapsedMills = 0L;
        try {
            runnable.run();
            elapsedMills = System.currentTimeMillis() - startMoment.createdAt;
            Measurement.save(startMoment.label, Measurement.DefaultColumns.createRow(startMoment.createdAt, elapsedMills));
        }
        catch (Exception ex) {
            try {
                elapsedMills = System.currentTimeMillis() - startMoment.createdAt;
                e = ex;
            }
            catch (Throwable throwable) {
                this.log(level, "%s costs %s%s.", startMoment.label, Duration.ofMillis(elapsedMills), e == null ? "" : " with " + e.getClass().getSimpleName());
                throw throwable;
            }
            this.log(level, "%s costs %s%s.", startMoment.label, Duration.ofMillis(elapsedMills), e == null ? "" : " with " + e.getClass().getSimpleName());
        }
        this.log(level, "%s costs %s%s.", startMoment.label, Duration.ofMillis(elapsedMills), e == null ? "" : " with " + e.getClass().getSimpleName());
        return this;
    }

    default public int getStackTraceCount(LogLevel level) {
        return 0;
    }

    default public String getCallStack(LogLevel level, Throwable ex) {
        int maxCount = this.getStackTraceCount(level);
        if (maxCount == 0) {
            return "";
        }
        List<StackTraceElement> stacks = StackTraceHelper.getFilteredStacks(maxCount, ex, new String[0]);
        if (stacks == null) {
            return "";
        }
        AtomicInteger counter = new AtomicInteger();
        String stackTrace = stacks.stream().map(s -> String.format("%s%s", StringUtils.repeat((String)" ", (int)(2 * counter.getAndIncrement())), s)).collect(Collectors.joining("\n..."));
        return stackTrace;
    }

    default public ILogger log(LogLevel level, String format, Object ... arguments) {
        if (this.canLog(level) && format != null) {
            String message = this.getMessage(level, format, arguments);
            this.save(message);
        }
        return this;
    }

    default public ILogger log(LogLevel level, Exception ex) {
        if (this.canLog(level) && ex != null) {
            Throwable cause = ex.getCause();
            if (cause != null) {
                String stackTrace = this.getCallStack(level, cause);
                String message = ex.getMessage();
                if (message != null) {
                    this.log(level, "%s: %s%s", message, cause.getMessage(), stackTrace);
                } else {
                    this.log(level, "%s: %s", cause.getMessage(), stackTrace);
                }
            } else {
                String stackTrace = this.getCallStack(level, ex);
                this.log(level, "%s: %s%s", ex.getClass().getSimpleName(), ex.getMessage(), StringUtils.isBlank((CharSequence)stackTrace) ? "" : "\n" + stackTrace);
            }
        }
        return this;
    }

    default public ILogger verbose(String format, Object ... args) {
        return this.log(LogLevel.verbose, StringHelper.tryFormatString(format, args), new Object[0]);
    }

    default public ILogger debug(String format, Object ... args) {
        return this.log(LogLevel.debug, StringHelper.tryFormatString(format, args), new Object[0]);
    }

    default public ILogger info(String format, Object ... args) {
        return this.log(LogLevel.info, StringHelper.tryFormatString(format, args), new Object[0]);
    }

    default public ILogger warning(String format, Object ... args) {
        return this.log(LogLevel.warning, StringHelper.tryFormatString(format, args), new Object[0]);
    }

    default public ILogger error(String format, Object ... args) {
        return this.log(LogLevel.error, StringHelper.tryFormatString(format, args), new Object[0]);
    }

    default public ILogger verbose(Exception ex) {
        return this.log(LogLevel.verbose, ex);
    }

    default public ILogger debug(Exception ex) {
        return this.log(LogLevel.debug, ex);
    }

    default public ILogger info(Exception ex) {
        return this.log(LogLevel.info, ex);
    }

    default public ILogger warning(Exception ex) {
        return this.log(LogLevel.warning, ex);
    }

    default public ILogger error(Exception ex) {
        return this.log(LogLevel.error, ex);
    }
}

