/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.logger;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.logger.LogLevel;
import io.github.cruisoring.logger.Logger;

public class InMemoryLogger
extends Logger {
    private final StringBuilder stringBuilder;

    public InMemoryLogger() {
        this(new StringBuilder(), LogLevel.verbose);
    }

    public InMemoryLogger(LogLevel minLevel) {
        this(new StringBuilder(), minLevel);
    }

    public InMemoryLogger(StringBuilder sb, LogLevel minLevel) {
        super((String log) -> Asserts.checkNoneNulls(sb, new Object[0]).append(log + "\n"), minLevel);
        this.stringBuilder = sb;
    }

    public InMemoryLogger(StringBuilder sb) {
        this(sb, LogLevel.verbose);
    }

    public StringBuilder getStringBuilder() {
        return this.stringBuilder;
    }

    public String getHistory() {
        return this.stringBuilder.toString();
    }
}

