/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.table;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.TypedList;
import io.github.cruisoring.table.IColumns;
import io.github.cruisoring.tuple.Tuple;
import io.github.cruisoring.tuple.Tuple2;
import io.github.cruisoring.tuple.WithValues;
import io.github.cruisoring.tuple.WithValues2;
import io.github.cruisoring.utility.ArrayHelper;
import io.github.cruisoring.utility.SimpleTypedList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;

public class Columns
implements IColumns {
    static final Map<WithValues2<IColumns, IColumns>, WithValues<Integer>> cachedMappings = new HashMap<WithValues2<IColumns, IColumns>, WithValues<Integer>>();
    public static final Comparator<String> NATURAL = String::compareTo;
    public static Comparator<String> DefaultNameComparator = String.CASE_INSENSITIVE_ORDER;
    private static final String _defaultEscapedPattern = "\\s|-|_";
    public static final Comparator<String> ESCAPED = (s1, s2) -> {
        String escaped1 = s1.replaceAll(_defaultEscapedPattern, "");
        String escaped2 = s2.replaceAll(_defaultEscapedPattern, "");
        return escaped1.compareTo(escaped2);
    };
    public static final Comparator<String> ESCAPED_CASE_INSENSITIVE = (s1, s2) -> {
        String escaped1 = s1.replaceAll(_defaultEscapedPattern, "");
        String escaped2 = s2.replaceAll(_defaultEscapedPattern, "");
        return escaped1.compareToIgnoreCase(escaped2);
    };
    final Comparator<String> nameComparator;
    final String[][] indexedColumns;
    final Map<String, Integer> columnIndexes;
    final List<String> columnNames;

    public Columns(String ... columnNames) {
        Asserts.assertAllNotNull(columnNames, new String[0][]);
        this.nameComparator = String::compareTo;
        HashMap<Integer, TypedList<String>> indexes = new HashMap<Integer, TypedList<String>>();
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        SimpleTypedList<String> names = new SimpleTypedList<String>(new String[0]);
        int len = columnNames.length;
        this.indexedColumns = new String[len][];
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            if (map.containsKey(columnName)) {
                throw new UnsupportedOperationException("Column name at index of " + i + " is duplicated with the one at index of " + map.get(columnName));
            }
            map.put(columnName, i);
            names.add(columnName);
            indexes.put(i, ArrayHelper.asList(columnName));
            this.indexedColumns[i] = new String[]{columnName};
        }
        this.columnIndexes = Collections.unmodifiableMap(map);
        this.columnNames = Collections.unmodifiableList(names);
    }

    public static Comparator<String> getEscapedComparator(String escapePattern) {
        Asserts.assertAllNotNull(escapePattern, new String[0]);
        return (s1, s2) -> {
            String escaped1 = s1.replaceAll(escapePattern, "");
            String escaped2 = s2.replaceAll(escapePattern, "");
            return escaped1.compareTo(escaped2);
        };
    }

    public static Comparator<String> getEscapedInsensitiveComparator(String escapePattern) {
        Asserts.assertAllNotNull(escapePattern, new String[0]);
        return (s1, s2) -> {
            String escaped1 = s1.replaceAll(escapePattern, "");
            String escaped2 = s2.replaceAll(escapePattern, "");
            return escaped1.compareToIgnoreCase(escaped2);
        };
    }

    public Columns(String[][] columnDefintions, Comparator<String> nameComparator) {
        Asserts.assertAllNotNull(columnDefintions, new String[0][][]);
        this.nameComparator = nameComparator == null ? DefaultNameComparator : nameComparator;
        int width = columnDefintions.length;
        if (width < 1) {
            throw new UnsupportedOperationException("No columns defined");
        }
        this.indexedColumns = columnDefintions;
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        SimpleTypedList<String> names = new SimpleTypedList<String>(new String[0]);
        for (int i = 0; i < width; ++i) {
            String[] columnDefinition = columnDefintions[i];
            int aliasLength = columnDefinition.length;
            if (aliasLength == 0 || Arrays.stream(columnDefinition).anyMatch(Objects::isNull)) {
                throw new UnsupportedOperationException("Unsupported definitons of column " + i);
            }
            for (int j = 0; j < aliasLength; ++j) {
                if (map.containsKey(columnDefinition[j])) {
                    throw new UnsupportedOperationException("Duplicated key: " + columnDefinition[j]);
                }
                map.put(columnDefinition[j], i);
            }
            names.add(columnDefinition[0]);
        }
        this.columnIndexes = Collections.unmodifiableMap(map);
        this.columnNames = Collections.unmodifiableList(names);
    }

    public Columns(String[][] columnDefintions) {
        this(columnDefintions, null);
    }

    @Override
    public Comparator<String> getNameComparator() {
        return this.nameComparator;
    }

    @Override
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public int width() {
        return this.columnNames.size();
    }

    @Override
    public Map<String, Integer> getColumnIndexes() {
        return this.columnIndexes;
    }

    @Override
    public String[][] getIndexedColumns() {
        return (String[][])ArrayHelper.create(String[].class, this.indexedColumns.length, i -> (String[])this.indexedColumns[i].clone());
    }

    @Override
    public WithValues<Integer> mapIndexes(IColumns other) {
        Asserts.assertAllNotNull(other, new IColumns[0]);
        if (this == other) {
            Integer[] indexes = (Integer[])IntStream.range(0, this.width()).boxed().toArray(Integer[]::new);
            return Tuple.setOfType(Integer.class, indexes);
        }
        Tuple2<Columns, IColumns> key = Tuple.create(this, other);
        WithValues<Integer> mappings = null;
        if (!cachedMappings.containsKey(key)) {
            SimpleTypedList<Integer> indexes = new SimpleTypedList<Integer>(new Integer[0]);
            block0: for (String[] alias : this.getIndexedColumns()) {
                for (int j = 0; j <= alias.length; ++j) {
                    if (j == alias.length) {
                        indexes.add(null);
                        continue block0;
                    }
                    WithValues2<Integer, Integer> indexPair = this.mapIndexes(alias[j], other);
                    if (indexPair == null) continue;
                    indexes.add(indexPair.getSecond());
                    continue block0;
                }
            }
            mappings = Tuple.setOf(indexes.toArray(new Integer[0]));
            cachedMappings.put(key, mappings);
        } else {
            mappings = cachedMappings.get(key);
        }
        return mappings;
    }

    @Override
    public int size() {
        return this.columnIndexes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.columnIndexes.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.columnIndexes.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.columnIndexes.containsValue(value);
    }

    @Override
    public Integer put(String key, Integer value) {
        return null;
    }

    @Override
    public Integer remove(Object key) {
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Integer> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        return this.columnIndexes.keySet();
    }

    @Override
    public Collection<Integer> values() {
        return this.columnIndexes.values();
    }

    @Override
    public Set<Map.Entry<String, Integer>> entrySet() {
        return this.columnIndexes.entrySet();
    }
}

