/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.table;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.table.IColumns;
import io.github.cruisoring.table.WithValuesByName;
import io.github.cruisoring.throwables.FunctionThrowable;
import io.github.cruisoring.throwables.PredicateThrowable;
import io.github.cruisoring.tuple.Tuple;
import io.github.cruisoring.tuple.WithValues;
import io.github.cruisoring.utility.ArrayHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public interface ITable<R extends WithValues>
extends Collection<WithValuesByName> {
    public IColumns getColumns();

    public int getColumnIndex(String var1);

    default public Class getColumnElementType(String columnName) {
        int index = this.getColumnIndex(columnName);
        if (index == -1) {
            return null;
        }
        Class[] elementTypes = this.getElementTypes();
        return index < elementTypes.length ? elementTypes[index] : Object.class;
    }

    public Collection<String> getDisplayedNames();

    public int width();

    public Class[] getElementTypes();

    default public boolean contains(Object ... values) {
        return this.contains((Object)Tuple.setOf(values));
    }

    public int indexOf(WithValuesByName var1);

    public int indexOf(Map<String, Object> var1);

    @Override
    public boolean add(WithValuesByName var1);

    public boolean addValues(Map<String, Object> var1);

    public boolean addValues(R var1);

    public WithValuesByName getRow(int var1);

    public WithValuesByName getRow(Map<String, Object> var1);

    public WithValuesByName[] getAllRows();

    public WithValuesByName[] getAllRows(Map<String, PredicateThrowable> var1);

    public Stream<WithValuesByName> streamOfRows(Map<String, PredicateThrowable> var1);

    public WithValuesByName getRow(int var1, IColumns var2);

    public ITable getView(IColumns var1);

    default public Map<Integer, String> getIndexedNames(Collection<String> valueKeys) {
        Asserts.checkNoneNulls(valueKeys, new Object[0]);
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        IColumns columns = this.getColumns();
        for (String key : valueKeys) {
            Integer index = columns.get(key);
            if (index == -1) {
                throw new UnsupportedOperationException("Value key of '" + key + "' is not recognizable!");
            }
            if (map.containsKey(index)) {
                throw new IllegalArgumentException(String.format("'%s' and '%s' are mapped to the same column %s @ %d", map.get(index), key, columns.getColumnNames().get(index), index));
            }
            map.put(index, key);
        }
        return map;
    }

    default public Object getCellValue(int rowIndex, int columnIndex) {
        Asserts.assertAllTrue(rowIndex >= 0, columnIndex >= 0);
        WithValuesByName row = this.getRow(rowIndex);
        return row == null || columnIndex >= row.getLength() ? null : row.getValue(columnIndex);
    }

    default public Object getCellValue(int rowIndex, String columnName) {
        Asserts.assertAllTrue(rowIndex >= 0, columnName != null);
        int columnIndex = this.getColumns().getOrDefault(columnName, -1);
        if (columnIndex == -1) {
            return null;
        }
        return this.getCellValue(rowIndex, columnIndex);
    }

    default public Object getColumnValues(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.width()) {
            return null;
        }
        int size = this.size();
        Object colValues = ArrayHelper.getNewArray(this.getElementTypes()[columnIndex], size);
        ArrayHelper.setAll(colValues, i -> this.getCellValue((int)i, columnIndex));
        return colValues;
    }

    default public Object getColumnValues(String columnName) {
        int columnIndex = this.getColumnIndex(Asserts.checkNoneNulls(columnName, new Object[0]));
        return this.getColumnValues(columnIndex);
    }

    public boolean replace(WithValuesByName var1, Map<String, Object> var2);

    public boolean update(WithValuesByName var1, Map<String, FunctionThrowable<WithValuesByName, Object>> var2);

    public int updateAll(Stream<WithValuesByName> var1, Map<String, FunctionThrowable<WithValuesByName, Object>> var2);

    default public boolean removeValues(Object ... values) {
        return this.remove(Tuple.setOf(values));
    }
}

