/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.table;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.table.IColumns;
import io.github.cruisoring.table.WithValuesByName;
import io.github.cruisoring.tuple.WithValues;
import io.github.cruisoring.utility.StringHelper;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class TupleRow<R extends WithValues>
implements WithValuesByName {
    final IColumns columns;
    final WithValues values;

    public TupleRow(IColumns indexes, WithValues values) {
        this.columns = Asserts.checkNoneNulls(indexes, values);
        this.values = values;
    }

    @Override
    public WithValues getValues() {
        return this.values;
    }

    @Override
    public int compareTo(Object o) {
        return this.values.compareTo(o);
    }

    @Override
    public Object getValue(int columnIndex) {
        return this.values.getValue(columnIndex);
    }

    @Override
    public int getLength() {
        return this.values.getLength();
    }

    @Override
    public IColumns getColumnIndexes() {
        return this.columns;
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public Set<Integer> getSignatures() {
        return this.values.getSignatures();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TupleRow)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TupleRow other = (TupleRow)obj;
        if (!other.canEqual(this) || other.getLength() != this.values.getLength()) {
            return false;
        }
        if (this.columns != other.columns) {
            Set thisColumns = this.columns.keySet();
            if (thisColumns.size() != other.columns.size() || !thisColumns.containsAll(other.columns.keySet())) {
                return false;
            }
            if (thisColumns.stream().anyMatch((? super T k) -> !this.columns.get(k).equals(other.columns.get(k)))) {
                return false;
            }
        }
        return this.values.equals(other.values);
    }

    @Override
    public boolean canEqual(Object obj) {
        if (!(obj instanceof TupleRow)) {
            return false;
        }
        TupleRow other = (TupleRow)obj;
        return this.values.canEqual(other.values);
    }

    public String toString() {
        int width = this.columns.width() > this.values.getLength() ? this.values.getLength() : this.columns.width();
        List<String> columnNames = this.columns.getColumnNames();
        String _string = IntStream.range(0, width).boxed().map(i -> StringHelper.tryFormatString("\"%s\"=%s", columnNames.get((int)i), this.getValue((int)i))).collect(Collectors.joining(", "));
        return "{" + _string + "}";
    }
}

