/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.throwables;

import io.github.cruisoring.OfThrowable;
import io.github.cruisoring.throwables.SupplierThrowable;
import java.util.function.BiFunction;
import java.util.function.Function;

@FunctionalInterface
public interface BiFunctionThrowable<T, U, R>
extends OfThrowable<R> {
    public R apply(T var1, U var2) throws Exception;

    default public R tryApply(T t, U u) {
        try {
            return this.apply(t, u);
        }
        catch (Exception cause) {
            return this.handle(cause);
        }
    }

    default public SupplierThrowable<R> asSupplierThrowable(T t, U u) {
        return () -> this.apply(t, u);
    }

    default public BiFunction<T, U, R> withHandler(Function<Exception, Object> ... exceptionHandlers) {
        if (exceptionHandlers == null || exceptionHandlers.length == 0) {
            return this::tryApply;
        }
        BiFunction<Object, Object, Object> function = (t, u) -> {
            try {
                return this.apply(t, u);
            }
            catch (Exception e) {
                return exceptionHandlers[0].apply(e);
            }
        };
        return function;
    }

    default public BiFunction<T, U, R> orElse(R defaultValue) {
        BiFunction<Object, Object, Object> function = (t, u) -> {
            try {
                return this.apply(t, u);
            }
            catch (Exception e) {
                return defaultValue;
            }
        };
        return function;
    }
}

