/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.throwables;

import io.github.cruisoring.OfThrowable;
import io.github.cruisoring.throwables.RunnableThrowable;
import java.util.function.Consumer;
import java.util.function.Function;

@FunctionalInterface
public interface ConsumerThrowable<T>
extends OfThrowable {
    public void accept(T var1) throws Exception;

    default public void tryAccept(T t) {
        try {
            this.accept(t);
        }
        catch (Exception e) {
            this.handle(e);
        }
    }

    default public RunnableThrowable asRunnableThrowable(T t) {
        return () -> this.accept(t);
    }

    default public Consumer<T> withHandler(Function<Exception, Object> ... exceptionHandlers) {
        if (exceptionHandlers == null || exceptionHandlers.length == 0) {
            return this::tryAccept;
        }
        Consumer<Object> consumer = t -> {
            try {
                this.accept(t);
            }
            catch (Exception e) {
                exceptionHandlers[0].apply(e);
            }
        };
        return consumer;
    }
}

