/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.throwables;

import io.github.cruisoring.OfThrowable;
import io.github.cruisoring.throwables.SupplierThrowable;
import java.util.function.Function;
import java.util.function.Predicate;

@FunctionalInterface
public interface PredicateThrowable<T>
extends OfThrowable<Boolean> {
    public boolean test(T var1) throws Exception;

    default public PredicateThrowable<T> reversed() {
        PredicateThrowable<Object> opposite = t -> !this.test(t);
        return opposite;
    }

    default public boolean tryTest(T t) {
        try {
            return this.test(t);
        }
        catch (Exception e) {
            return (Boolean)this.handle(e);
        }
    }

    default public SupplierThrowable<Boolean> asSupplierThrowable(T t) {
        return () -> this.test(t);
    }

    default public Predicate<T> withHandler(Function<Exception, Object> ... exceptionHandlers) {
        if (exceptionHandlers == null || exceptionHandlers.length == 0) {
            return this::tryTest;
        }
        Predicate<Object> predicate = t -> {
            try {
                return this.test(t);
            }
            catch (Exception e) {
                return (Boolean)exceptionHandlers[0].apply(e);
            }
        };
        return predicate;
    }

    default public Predicate<T> orElse(boolean defaultValue) {
        Predicate<Object> predicate = t -> {
            try {
                return this.test(t);
            }
            catch (Exception e) {
                return defaultValue;
            }
        };
        return predicate;
    }
}

