/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.throwables;

import io.github.cruisoring.OfThrowable;
import java.util.function.Function;

@FunctionalInterface
public interface RunnableThrowable
extends OfThrowable {
    public void run() throws Exception;

    default public void tryRun() {
        try {
            this.run();
        }
        catch (Exception e) {
            this.handle(e);
        }
    }

    default public Runnable withHandler(Function<Exception, Object> ... exceptionHandlers) {
        if (exceptionHandlers == null || exceptionHandlers.length == 0) {
            return this::tryRun;
        }
        return () -> {
            try {
                this.run();
            }
            catch (Exception e) {
                exceptionHandlers[0].apply(e);
            }
        };
    }
}

