/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.utility;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.TypedList;
import io.github.cruisoring.utility.ArrayHelper;
import io.github.cruisoring.utility.SetHelper;
import io.github.cruisoring.utility.StringHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Supplier;

public class ReadOnlyList<E>
implements TypedList<E> {
    static final String UNSUPPORTED = "Writing operation is not supported by ReadOnlyList<E>";
    protected final Class<? extends E> elementType;
    protected final E[] elements;
    protected final int upperIndex;

    public ReadOnlyList(Class<? extends E> elementType, Collection<E> collection) {
        this.elementType = Asserts.checkNotNull(elementType, "ElementType must be specified");
        this.upperIndex = Asserts.checkNotNull(collection, "No Collection spedified!").size();
        Iterator iterator = collection.iterator();
        this.elements = (Object[])ArrayHelper.create(elementType, this.upperIndex, i -> iterator.next());
    }

    public ReadOnlyList(Class<? extends E> elementType, E ... values) {
        this.elementType = Asserts.checkNotNull(elementType, "ElementType must be specified");
        if (values == null) {
            this.upperIndex = 1;
            this.elements = (Object[])ArrayHelper.getNewArray(elementType, 1);
        } else {
            this.upperIndex = values.length;
            this.elements = Arrays.copyOf(values, values.length);
        }
    }

    public ReadOnlyList(E ... values) {
        this(values == null ? Object.class : values.getClass().getComponentType(), values);
    }

    public ReadOnlyList(E[] values, int from, int to) {
        Asserts.assertAllFalse(values == null, from < 0, to > values.length, from > to);
        this.elementType = values.getClass().getComponentType();
        this.elements = Arrays.copyOfRange(values, from, to);
        this.upperIndex = this.elements.length;
    }

    public ReadOnlyList(Supplier<E[]> initValueSupplier) {
        Asserts.assertNotNull(initValueSupplier, "The supplier of init values must be specified");
        this.elements = initValueSupplier.get();
        this.elementType = this.elements.getClass().getComponentType();
        this.upperIndex = this.elements.length;
    }

    @Override
    public Class<? extends E> getElementType() {
        return this.elementType;
    }

    @Override
    public int removeByIndexes(Integer ... indexes) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public boolean insertAll(int index, E ... array) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public boolean appendAll(E ... array) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public ReadOnlyList<E> asReadOnly() {
        return this;
    }

    @Override
    public int size() {
        return this.upperIndex;
    }

    @Override
    public boolean isEmpty() {
        return this.upperIndex == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new ReadOnlyListIterator();
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elements, this.upperIndex);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a == null) {
            return this.toArray();
        }
        if (a.length < this.upperIndex) {
            return (Object[])ArrayHelper.create(a.getClass().getComponentType(), this.upperIndex, i -> this.elements[i]);
        }
        ArrayHelper.setAll(a, i -> i < this.upperIndex ? this.elements[i] : null);
        return a;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Set<E> elementSet = SetHelper.asSet(this.elements);
        return elementSet.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public E get(int index) {
        Asserts.assertAllFalse(index < 0, index > this.upperIndex);
        return this.elements[index];
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException(UNSUPPORTED);
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.upperIndex; ++i) {
                if (this.elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.upperIndex; ++i) {
                if (!o.equals(this.elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            for (int i = this.upperIndex - 1; i >= 0; --i) {
                if (this.elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.upperIndex - 1; i >= 0; --i) {
                if (!o.equals(this.elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ReadOnlyListIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        Asserts.assertAllFalse(index < 0, index > this.upperIndex);
        return new ReadOnlyListIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        Asserts.assertAllFalse(fromIndex < 0, toIndex > this.upperIndex, fromIndex > toIndex);
        return new ReadOnlyList<E>(this.elementType, Arrays.copyOfRange(this.elements, fromIndex, toIndex));
    }

    public class ReadOnlyListIterator
    implements ListIterator<E> {
        int fromInclusive;
        int toExclusive;
        int cursor;
        int lastReturned = -1;

        public ReadOnlyListIterator() {
            this(0);
        }

        public ReadOnlyListIterator(int position) {
            this(position, 0, this$0.upperIndex);
        }

        public ReadOnlyListIterator(int position, int from, int to) {
            Asserts.assertAllFalse(from < 0, to > ReadOnlyList.this.upperIndex, from > to, position < from, position > to);
            this.fromInclusive = from;
            this.toExclusive = to;
            this.cursor = this.fromInclusive;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.toExclusive;
        }

        @Override
        public E next() {
            if (this.cursor >= this.toExclusive) {
                throw new NoSuchElementException(StringHelper.tryFormatString("No next element when cursor(%d) >= toExclusive(%d)", this.cursor, this.toExclusive));
            }
            this.lastReturned = this.cursor++;
            return ReadOnlyList.this.elements[this.lastReturned];
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > this.fromInclusive;
        }

        @Override
        public E previous() {
            if (this.cursor <= this.fromInclusive) {
                throw new NoSuchElementException(StringHelper.tryFormatString("No previous element when cursor(%d) <= fromInclusive(%d)", this.cursor, this.fromInclusive));
            }
            this.lastReturned = --this.cursor;
            return ReadOnlyList.this.elements[this.lastReturned];
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void add(E e) {
            Asserts.fail("No adding support of ReadOnlyListIterator", new Object[0]);
        }

        @Override
        public void set(E e) {
            Asserts.fail("No setting support of ReadOnlyListIterator", new Object[0]);
        }

        @Override
        public void remove() {
            Asserts.fail("No removing support of ReadOnlyListIterator", new Object[0]);
        }
    }
}

