/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.utility;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.throwables.SupplierThrowable;
import io.github.cruisoring.utility.ArrayHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;

public class SetHelper {
    public static Supplier<Set> defaultSetSupplier = HashSet::new;

    private SetHelper() {
    }

    public static <T> Set<T> asSet(SupplierThrowable<Set<T>> setSupplier, T ... elements) {
        Set set;
        Set set2 = set = setSupplier == null ? defaultSetSupplier.get() : (Set)setSupplier.orElse(null).get();
        if (elements == null) {
            elements = (Object[])ArrayHelper.create(Object.class, 1, i -> null);
        }
        Asserts.assertAllFalse(set == null, null == elements);
        for (int i2 = 0; i2 < elements.length; ++i2) {
            set.add(elements[i2]);
        }
        return set;
    }

    public static <T> Set<T> asSet(Collection<T> elements, SupplierThrowable<Set<T>> setSupplier) {
        Set set = setSupplier == null ? defaultSetSupplier.get() : (Set)setSupplier.orElse(null).get();
        Asserts.assertAllFalse(set == null, null == elements);
        set.addAll(elements);
        return set;
    }

    public static <T> Set<T> asSet(T ... elements) {
        return SetHelper.asSet(null, elements);
    }

    public static <T> Set<T> asSet(Collection<T> elements) {
        if (elements instanceof Set) {
            return (Set)elements;
        }
        return SetHelper.asSet(elements, null);
    }

    public static <T> Set<T> asHashSet(T ... elements) {
        return SetHelper.asSet(HashSet::new, elements);
    }

    public static <T> Set<T> asTreeSet(T ... elements) {
        return SetHelper.asSet(TreeSet::new, elements);
    }

    public static <T> Set<T> asLinkedHashSet(T ... elements) {
        return SetHelper.asSet(LinkedHashSet::new, elements);
    }

    public static <T> Set<T> union(Set<T> setA, Set<T> setB, Set<T> ... others) {
        Set set = defaultSetSupplier.get();
        Asserts.checkNoneNulls(set, setA, setB, others).addAll(setA);
        set.addAll(setB);
        for (int i = 0; i < others.length; ++i) {
            set.addAll(others[i]);
        }
        return set;
    }

    public static <T> Set<T> intersection(Set<T> setA, Set<T> setB, Set<T> ... others) {
        Set intersection = defaultSetSupplier.get();
        Asserts.checkNoneNulls(intersection, setA, setB, others).addAll(setA);
        intersection.retainAll(setB);
        for (int i = 0; i < others.length; ++i) {
            if (intersection.isEmpty()) {
                return intersection;
            }
            intersection.retainAll(others[i]);
        }
        return intersection;
    }

    public static <T> Set<T> difference(Set<T> setA, Set<T> setB) {
        Set set = defaultSetSupplier.get();
        Asserts.checkNoneNulls(set, setA, setB).addAll(setA);
        set.removeAll(setB);
        return set;
    }

    public static <T> Set<T> symmetricDifference(Set<T> setA, Set<T> setB) {
        Set set = defaultSetSupplier.get();
        Asserts.checkNoneNulls(set, setA, setB).addAll(setA);
        for (T element : setB) {
            if (set.add(element)) continue;
            set.remove(element);
        }
        return set;
    }

    public static boolean isSameAs(Set setA, Set setB) {
        Asserts.assertAllNotNull(setA, setB);
        if (setA.size() != setB.size()) {
            return false;
        }
        Set difference = SetHelper.difference(setA, setB);
        return difference.isEmpty();
    }
}

