/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.utility;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.TypedList;
import io.github.cruisoring.throwables.PredicateThrowable;
import io.github.cruisoring.utility.ArrayHelper;
import io.github.cruisoring.utility.ReadOnlyList;
import io.github.cruisoring.utility.SetHelper;
import io.github.cruisoring.utility.TypedListIterator;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.IntStream;

public class SimpleTypedList<E>
implements TypedList<E> {
    static final int DEFAULT_CAPACITY = 1024;
    static final int MAX_CAPACITY = 0x10000000;
    protected final Class<? extends E> elementType;
    int capacity;
    E[] elements;
    int upperIndex;

    public SimpleTypedList(Class<? extends E> elementType, int initialCapacity, Collection<E> initValueCollection) {
        this.elementType = Asserts.checkNotNull(elementType, "ElementType must be specified");
        initialCapacity = Math.max(initialCapacity, Asserts.checkNotNull(initValueCollection, "No Collection spedified!").size());
        this.resize(initialCapacity);
        this.upperIndex = 0;
        Iterator<Object> iterator = initValueCollection.iterator();
        iterator.forEachRemaining(e -> {
            this.elements[this.upperIndex++] = e;
        });
    }

    public SimpleTypedList(E[] initValues, int from, int to) {
        Asserts.assertAllFalse(initValues == null, from < 0, to > initValues.length, from > to);
        this.elementType = initValues.getClass().getComponentType();
        this.elements = Arrays.copyOfRange(initValues, from, to);
        this.upperIndex = this.elements.length;
    }

    public SimpleTypedList(Class<? extends E> elementType, E ... values) {
        this.elementType = Asserts.checkNotNull(elementType, "ElementType must be specified");
        values = values != null ? values : (Object[])ArrayHelper.create(elementType, 1, i -> null);
        this.elements = Arrays.copyOf(values, values.length);
        this.upperIndex = this.elements.length;
    }

    public SimpleTypedList(E ... values) {
        this(values == null ? Object.class : values.getClass().getComponentType(), values);
    }

    static int getDefaultCapacity(int capacity) {
        if (capacity <= 1024) {
            return 1024;
        }
        Asserts.assertTrue(capacity < 0x10000000, "The desirable capacity is greater than MAX_CAPCITY");
        int result = 1024;
        while ((result *= 2) < capacity) {
        }
        return result;
    }

    protected void ensureCapacity(int extraSize, int index) {
        E[] old = this.elements;
        if (extraSize + this.upperIndex > this.capacity) {
            this.capacity = SimpleTypedList.getDefaultCapacity(extraSize + this.upperIndex);
            this.resize(this.capacity);
        }
        if (index < this.upperIndex) {
            System.arraycopy(old, index, this.elements, index + extraSize, this.upperIndex - index);
        }
        if (index > 0 && old != this.elements) {
            System.arraycopy(old, 0, this.elements, 0, index);
        }
    }

    public E[] resize(int capacity) {
        Asserts.assertTrue(capacity >= 0, "The capacity must be greater or equal to 0");
        E[] old = this.elements;
        this.capacity = capacity;
        this.elements = (Object[])ArrayHelper.getNewArray(this.elementType, capacity);
        return old;
    }

    @Override
    public Class<? extends E> getElementType() {
        return this.elementType;
    }

    @Override
    public Integer[] matchedIndexes(PredicateThrowable<E> elementPredicate) {
        return (Integer[])IntStream.range(0, this.upperIndex).filter(i -> elementPredicate.orElse(false).test(this.elements[i])).boxed().toArray(Integer[]::new);
    }

    @Override
    public int removeByIndexes(Integer ... indexes) {
        int i;
        Set<Integer> set = SetHelper.asSet(indexes);
        int newSize = 0;
        int last = -1;
        int removed = 0;
        int length = this.upperIndex;
        for (i = 0; i < length; ++i) {
            if (!set.contains(i)) {
                if (last != -1) {
                    this.elements[last++] = this.elements[i];
                }
                ++newSize;
                continue;
            }
            ++removed;
            if (last != -1) continue;
            last = i;
        }
        for (i = newSize; i < length; ++i) {
            this.elements[i] = null;
        }
        this.upperIndex = newSize;
        return removed;
    }

    @Override
    public boolean insertAll(int index, E ... array) {
        array = array == null ? (Object[])ArrayHelper.create(this.elementType, 1, i -> null) : array;
        Asserts.assertAllFalse(index < 0, index > this.upperIndex);
        int extraSize = array.length;
        if (extraSize == 0) {
            return false;
        }
        this.ensureCapacity(extraSize, index);
        System.arraycopy(array, 0, this.elements, index, extraSize);
        this.upperIndex += extraSize;
        return true;
    }

    @Override
    public boolean appendAll(E ... array) {
        array = array == null ? (Object[])ArrayHelper.create(this.elementType, 1, i -> null) : array;
        return this.insertAll(this.upperIndex, array);
    }

    @Override
    public ReadOnlyList<E> asReadOnly() {
        return new ReadOnlyList<E>(this.elements, 0, this.upperIndex);
    }

    public E push(E e) {
        this.add(e);
        return e;
    }

    public E pop() {
        if (this.upperIndex == 0) {
            throw new EmptyStackException();
        }
        E last = this.elements[this.upperIndex - 1];
        this.elements[this.upperIndex--] = null;
        return last;
    }

    @Override
    public int size() {
        return this.upperIndex;
    }

    @Override
    public boolean isEmpty() {
        return this.upperIndex == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new TypedListIterator(this);
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elements, this.upperIndex);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a == null) {
            return this.toArray();
        }
        if (a.length < this.upperIndex) {
            return (Object[])ArrayHelper.create(a.getClass().getComponentType(), this.upperIndex, i -> this.elements[i]);
        }
        ArrayHelper.setAll(a, i -> i < this.upperIndex ? this.elements[i] : null);
        return a;
    }

    @Override
    public boolean add(E e) {
        if (this.upperIndex >= this.capacity) {
            this.ensureCapacity(1, this.upperIndex);
        }
        this.elements[this.upperIndex] = e;
        ++this.upperIndex;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index < 0) {
            return false;
        }
        int numMoved = this.upperIndex - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elements, index + 1, this.elements, index, numMoved);
        }
        this.elements[--this.upperIndex] = null;
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Set<E> elementSet = SetHelper.asSet(this.elements);
        return elementSet.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.upperIndex, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (c == null) {
            return false;
        }
        Asserts.assertAllFalse(index < 0, index > this.upperIndex);
        if (c.isEmpty()) {
            return false;
        }
        int extraSize = c.size();
        this.ensureCapacity(extraSize, index);
        Iterator<E> iterator = c.iterator();
        for (int i = 0; i < extraSize; ++i) {
            Array.set(this.elements, index + i, iterator.next());
        }
        this.upperIndex += extraSize;
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c == null) {
            return false;
        }
        Set<?> set = SetHelper.asSet(c);
        return this.removeAllMatched(set::contains);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c == null) {
            return false;
        }
        Set<?> set = SetHelper.asSet(c);
        return this.removeAllMatched(e -> !set.contains(e));
    }

    @Override
    public void clear() {
        this.resize(1024);
        this.upperIndex = 0;
    }

    @Override
    public E get(int index) {
        Asserts.assertAllFalse(index < 0, index > this.upperIndex);
        return this.elements[index];
    }

    @Override
    public E set(int index, E element) {
        E old = this.get(index);
        this.elements[index] = element;
        return old;
    }

    @Override
    public void add(int index, E element) {
        Asserts.assertAllFalse(index < 0, index > this.upperIndex);
        this.ensureCapacity(1, index);
        this.elements[index] = element;
        ++this.upperIndex;
    }

    @Override
    public E remove(int index) {
        E old = this.get(index);
        if (index < this.upperIndex - 1) {
            System.arraycopy(this.elements, index + 1, this.elements, index, this.upperIndex - 1 - index);
        }
        this.elements[--this.upperIndex] = null;
        return old;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.upperIndex; ++i) {
                if (this.elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.upperIndex; ++i) {
                if (!o.equals(this.elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            for (int i = this.upperIndex - 1; i >= 0; --i) {
                if (this.elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.upperIndex - 1; i >= 0; --i) {
                if (!o.equals(this.elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new TypedListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        Asserts.assertAllFalse(index < 0, index > this.upperIndex);
        return new TypedListIterator(this, index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        Asserts.assertAllFalse(fromIndex < 0, toIndex > this.upperIndex, fromIndex > toIndex);
        return new SimpleTypedList<E>(this.elementType, Arrays.copyOfRange(this.elements, fromIndex, toIndex));
    }
}

