/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.utility;

import io.github.cruisoring.logger.ILogger;
import io.github.cruisoring.logger.Logger;
import io.github.cruisoring.tuple.Tuple;
import io.github.cruisoring.utility.StringHelper;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class StackTraceHelper {
    static final String[] defaultFilters = new String[]{Logger.class.getName(), ILogger.class.getName(), StackTraceHelper.class.getName(), "sun.reflect.NativeMethodAccessorImpl", "java.lang.Thread"};

    private StackTraceHelper() {
    }

    public static List<StackTraceElement> getFilteredStacks(int maxCount, Throwable ex, String ... filters) {
        if (maxCount == 0) {
            return null;
        }
        Tuple<String> tuple = Tuple.setOf(filters.length == 0 ? defaultFilters : filters);
        StackTraceElement[] stacks = ex == null ? Thread.currentThread().getStackTrace() : ex.getStackTrace();
        int first = -1;
        int last = -1;
        for (int i = 0; i < stacks.length; ++i) {
            String className = stacks[i].getClassName();
            if (first == -1) {
                if (tuple.anyMatch(className::equals)) continue;
                first = i;
            }
            last = i;
            if (tuple.anyMatch(className::equals)) break;
        }
        if (maxCount > 0 && last - first > maxCount) {
            last = first + maxCount;
        } else if (maxCount < 0 && first - last < maxCount) {
            first = last + maxCount < 0 ? 0 : last + maxCount;
        }
        List<StackTraceElement> concerned = Arrays.stream(stacks).skip(first).limit((long)last - (long)first).collect(Collectors.toList());
        return concerned;
    }

    public static List<String> getFilteredCallers(String ... filters) {
        List<StackTraceElement> stacks = StackTraceHelper.getFilteredStacks(500, null, filters);
        List<String> classNames = stacks.stream().map(StackTraceElement::getClassName).collect(Collectors.toList());
        return classNames;
    }

    public static Class getCallerClass(String ... filters) {
        List<String> callers = StackTraceHelper.getFilteredCallers(filters);
        try {
            String className = callers.get(callers.size() - 1);
            Class<?> callerClass = Class.forName(className);
            return callerClass;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static StackTraceElement getCallerStackByEntry(Exception ex, String ... calledKeywords) {
        if (calledKeywords == null || calledKeywords.length == 0) {
            calledKeywords = new String[]{StackTraceHelper.class.getSimpleName() + ".java"};
        }
        boolean notMatched = true;
        for (StackTraceElement stack : ex == null ? Thread.currentThread().getStackTrace() : ex.getStackTrace()) {
            String stackString = stack.toString();
            if (notMatched) {
                if (!StringHelper.containsAny(stackString, calledKeywords)) continue;
                notMatched = false;
                continue;
            }
            if (StringHelper.containsAny(stackString, calledKeywords)) continue;
            return stack;
        }
        return null;
    }

    public static String getCallerLabel(Exception ex, String ... calledKeywords) {
        StackTraceElement stack = StackTraceHelper.getCallerStackByEntry(ex, calledKeywords);
        String label = stack == null ? null : StringHelper.tryFormatString("%s(%s:%d)", stack.getMethodName(), stack.getFileName(), stack.getLineNumber());
        return label;
    }
}

