/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.OfThrowable;
import io.github.cruisoring.repository.TupleRepository3;
import io.github.cruisoring.repository.TupleRepository6;
import io.github.cruisoring.throwables.BiFunctionThrowable;
import io.github.cruisoring.throwables.FunctionThrowable;
import io.github.cruisoring.throwables.TriConsumerThrowable;
import io.github.cruisoring.throwables.TriFunctionThrowable;
import io.github.cruisoring.tuple.Tuple;
import io.github.cruisoring.tuple.Tuple2;
import io.github.cruisoring.tuple.Tuple3;
import io.github.cruisoring.tuple.Tuple6;
import io.github.cruisoring.utility.ArrayHelper;
import io.github.cruisoring.utility.SimpleTypedList;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import sun.reflect.ConstantPool;

public class TypeHelper {
    static final int NULL_NODE = -1;
    private static final Class OBJECT_CLASS = Object.class;
    private static final int NORMAL_VALUE_NODE = 0;
    public static int EMPTY_ARRAY_NODE = -2;
    public static int EMPTY_COLLECTION_NODE = -3;
    static int _defaultParallelEvaluationThread = 100000;
    public static boolean EMPTY_ARRAY_AS_DEFAULT = false;
    public static int PARALLEL_EVALUATION_THRESHOLD = _defaultParallelEvaluationThread;
    public static EqualityStategy DEFAULT_EMPTY_EQUALITY = EqualityStategy.TypeIgnored;
    private static final BiFunctionThrowable<Object, Integer, Object> arrayGet = Array::get;
    private static final TriConsumerThrowable<Object, Integer, Object> arraySet = Array::set;
    static final TupleRepository6<Class, Predicate<Class>, FunctionThrowable<Integer, Object>, Class, TriConsumerThrowable<Object, Integer, Object>, TriFunctionThrowable<Object, Integer, Integer, Object>, Function<Object, String>> classOperators = TupleRepository6.fromKey(new HashMap<Class, Tuple6<Predicate<Class>, FunctionThrowable<Integer, Object>, Class, TriConsumerThrowable<Object, Integer, Object>, TriFunctionThrowable<Object, Integer, Integer, Object>, Function<Object, String>>>(){
        {
            Predicate<Class> classPredicate = clazz -> Integer.TYPE.equals(clazz) || Integer.class.equals(clazz);
            this.put(Integer.TYPE, Tuple.create(classPredicate, int[]::new, int[].class, (array, index, value) -> {
                ((int[])array)[index.intValue()] = (Integer)value;
            }, (array, from, to) -> Arrays.copyOfRange((int[])array, (int)from, (int)to), array -> Arrays.toString((int[])array)));
            this.put(Integer.class, Tuple.create(classPredicate, Integer[]::new, Integer[].class, arraySet, (array, from, to) -> Arrays.copyOfRange((Integer[])array, (int)from, (int)to), array -> Arrays.toString((Object[])((Integer[])array))));
            classPredicate = clazz -> Byte.TYPE.equals(clazz) || Byte.class.equals(clazz);
            this.put(Byte.TYPE, Tuple.create(classPredicate, byte[]::new, byte[].class, (array, index, value) -> {
                ((byte[])array)[index.intValue()] = (Byte)value;
            }, (array, from, to) -> Arrays.copyOfRange((byte[])array, (int)from, (int)to), array -> Arrays.toString((byte[])array)));
            this.put(Byte.class, Tuple.create(classPredicate, Byte[]::new, Byte[].class, arraySet, (array, from, to) -> Arrays.copyOfRange((Byte[])array, (int)from, (int)to), array -> Arrays.toString((Object[])((Byte[])array))));
            classPredicate = clazz -> Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz);
            this.put(Boolean.TYPE, Tuple.create(classPredicate, boolean[]::new, boolean[].class, (array, index, value) -> {
                ((boolean[])array)[index.intValue()] = (Boolean)value;
            }, (array, from, to) -> Arrays.copyOfRange((boolean[])array, (int)from, (int)to), array -> Arrays.toString((boolean[])array)));
            this.put(Boolean.class, Tuple.create(classPredicate, Boolean[]::new, Boolean[].class, arraySet, (array, from, to) -> Arrays.copyOfRange((Boolean[])array, (int)from, (int)to), array -> Arrays.toString((Object[])((Boolean[])array))));
            classPredicate = clazz -> Character.TYPE.equals(clazz) || Character.class.equals(clazz);
            this.put(Character.TYPE, Tuple.create(classPredicate, char[]::new, char[].class, (array, index, value) -> {
                ((char[])array)[index.intValue()] = ((Character)value).charValue();
            }, (array, from, to) -> Arrays.copyOfRange((char[])array, (int)from, (int)to), array -> Arrays.toString((char[])array)));
            this.put(Character.class, Tuple.create(classPredicate, Character[]::new, Character[].class, arraySet, (array, from, to) -> Arrays.copyOfRange((Character[])array, (int)from, (int)to), array -> Arrays.toString((Object[])((Character[])array))));
            classPredicate = clazz -> Short.TYPE.equals(clazz) || Short.class.equals(clazz);
            this.put(Short.TYPE, Tuple.create(classPredicate, short[]::new, short[].class, (array, index, value) -> {
                ((short[])array)[index.intValue()] = (Short)value;
            }, (array, from, to) -> Arrays.copyOfRange((short[])array, (int)from, (int)to), array -> Arrays.toString((short[])array)));
            this.put(Short.class, Tuple.create(classPredicate, Short[]::new, Short[].class, arraySet, (array, from, to) -> Arrays.copyOfRange((Short[])array, (int)from, (int)to), array -> Arrays.toString((Object[])((Short[])array))));
            classPredicate = clazz -> Long.TYPE.equals(clazz) || Long.class.equals(clazz);
            this.put(Long.TYPE, Tuple.create(classPredicate, long[]::new, long[].class, (array, index, value) -> {
                ((long[])array)[index.intValue()] = (Long)value;
            }, (array, from, to) -> Arrays.copyOfRange((long[])array, (int)from, (int)to), array -> Arrays.toString((long[])array)));
            this.put(Long.class, Tuple.create(classPredicate, Long[]::new, Long[].class, arraySet, (array, from, to) -> Arrays.copyOfRange((Long[])array, (int)from, (int)to), array -> Arrays.toString((Object[])((Long[])array))));
            classPredicate = clazz -> Double.TYPE.equals(clazz) || Double.class.equals(clazz);
            this.put(Double.TYPE, Tuple.create(classPredicate, double[]::new, double[].class, (array, index, value) -> {
                ((double[])array)[index.intValue()] = (Double)value;
            }, (array, from, to) -> Arrays.copyOfRange((double[])array, (int)from, (int)to), array -> Arrays.toString((double[])array)));
            this.put(Double.class, Tuple.create(classPredicate, Double[]::new, Double[].class, arraySet, (array, from, to) -> Arrays.copyOfRange((Double[])array, (int)from, (int)to), array -> Arrays.toString((Object[])((Double[])array))));
            classPredicate = clazz -> Float.TYPE.equals(clazz) || Float.class.equals(clazz);
            this.put(Float.TYPE, Tuple.create(classPredicate, float[]::new, float[].class, (array, index, value) -> {
                ((float[])array)[index.intValue()] = ((Float)value).floatValue();
            }, (array, from, to) -> Arrays.copyOfRange((float[])array, (int)from, (int)to), array -> Arrays.toString((float[])array)));
            this.put(Float.class, Tuple.create(classPredicate, Float[]::new, Float[].class, arraySet, (array, from, to) -> Arrays.copyOfRange((Float[])array, (int)from, (int)to), array -> Arrays.toString((Object[])((Float[])array))));
        }
    }, null, TypeHelper::makeClassOperators);
    private static final Function<Object, Object> returnsSelf = obj -> obj;
    private static final Function<Object, Object> mapsToNull = obj -> null;
    static final TupleRepository3<OfThrowable, Boolean, Class[], Class> lambdaGenericInfoRepository = TupleRepository3.fromKey(TypeHelper::getLambdaGenericInfo);
    private static final TupleRepository6<Class, Boolean, Object, Class, Function<Object, Object>, Function<Object, Object>, Function<Object, Object>> baseTypeConverters = TupleRepository6.fromKey(new HashMap(){
        {
            Function<Object, Object> convertWithCasting = returnsSelf;
            this.put(Boolean.TYPE, Tuple.create(true, false, Boolean.class, convertWithCasting, convertWithCasting, convertWithCasting));
            convertWithCasting = fromElement -> (Boolean)fromElement;
            this.put(Boolean.class, Tuple.create(false, false, Boolean.TYPE, convertWithCasting, convertWithCasting, convertWithCasting));
            convertWithCasting = returnsSelf;
            this.put(Byte.TYPE, Tuple.create(true, (byte)0, Byte.class, convertWithCasting, convertWithCasting, convertWithCasting));
            convertWithCasting = fromElement -> (Byte)fromElement;
            this.put(Byte.class, Tuple.create(false, (byte)0, Byte.TYPE, convertWithCasting, convertWithCasting, convertWithCasting));
            convertWithCasting = returnsSelf;
            this.put(Character.TYPE, Tuple.create(true, Character.valueOf('\u0000'), Character.class, convertWithCasting, convertWithCasting, convertWithCasting));
            convertWithCasting = fromElement -> (Character)fromElement;
            this.put(Character.class, Tuple.create(false, Character.valueOf('\u0000'), Character.TYPE, convertWithCasting, convertWithCasting, convertWithCasting));
            convertWithCasting = returnsSelf;
            this.put(Double.TYPE, Tuple.create(true, 0.0, Double.class, convertWithCasting, convertWithCasting, convertWithCasting));
            convertWithCasting = fromElement -> (Double)fromElement;
            this.put(Double.class, Tuple.create(false, 0.0, Double.TYPE, convertWithCasting, convertWithCasting, convertWithCasting));
            convertWithCasting = returnsSelf;
            this.put(Float.TYPE, Tuple.create(true, Float.valueOf(0.0f), Float.class, convertWithCasting, convertWithCasting, convertWithCasting));
            convertWithCasting = fromElement -> (Float)fromElement;
            this.put(Float.class, Tuple.create(false, Float.valueOf(0.0f), Float.TYPE, convertWithCasting, convertWithCasting, convertWithCasting));
            convertWithCasting = returnsSelf;
            this.put(Integer.TYPE, Tuple.create(true, 0, Integer.class, convertWithCasting, convertWithCasting, convertWithCasting));
            convertWithCasting = fromElement -> (Integer)fromElement;
            this.put(Integer.class, Tuple.create(false, 0, Integer.TYPE, convertWithCasting, convertWithCasting, convertWithCasting));
            convertWithCasting = returnsSelf;
            this.put(Long.TYPE, Tuple.create(true, 0L, Long.class, convertWithCasting, convertWithCasting, convertWithCasting));
            convertWithCasting = fromElement -> (Long)fromElement;
            this.put(Long.class, Tuple.create(false, 0L, Long.TYPE, convertWithCasting, convertWithCasting, convertWithCasting));
            convertWithCasting = returnsSelf;
            this.put(Short.TYPE, Tuple.create(true, (short)0, Short.class, convertWithCasting, convertWithCasting, convertWithCasting));
            convertWithCasting = fromElement -> (Short)fromElement;
            this.put(Short.class, Tuple.create(false, (short)0, Short.TYPE, convertWithCasting, convertWithCasting, convertWithCasting));
        }
    }, null, TypeHelper::makeBaseTypeConverters);
    private static final TupleRepository3.TupleKeys2<Class, Class, Function<Object, Object>, Function<Object, Object>, Function<Object, Object>> deepConverters = TupleRepository3.fromKeys2(TypeHelper::getDeepEvaluators);

    private static final Method _getConstantPool() throws NoSuchMethodException {
        Method method = Class.class.getDeclaredMethod("getConstantPool", new Class[0]);
        method.setAccessible(true);
        return method;
    }

    private static <T> TriFunctionThrowable<Object, Integer, Integer, Object> asGenericCopyOfRange(Class<T> componentType) {
        return (array, from, to) -> Arrays.copyOfRange((Object[])array, (int)from, (int)to);
    }

    private static <T> Function<Object, String> getDeepToString(Class<T> componentClass) {
        Asserts.assertAllNotNull(componentClass, new Class[0]);
        Function<Object, String> toString = obj -> {
            Object[] objects = (Object[])obj;
            int length = objects.length;
            CharSequence[] strings = new String[length];
            for (int i = 0; i < length; ++i) {
                Object element = objects[i];
                if (element == null) {
                    strings[i] = "null";
                    continue;
                }
                Class<?> elementClass = element.getClass();
                if (elementClass.isArray()) {
                    Function<Object, String> elementToString = TypeHelper.getArrayToString(elementClass.getComponentType());
                    strings[i] = elementToString.apply(element);
                    continue;
                }
                strings[i] = element.toString();
            }
            return String.format("[%s]", String.join((CharSequence)", ", strings));
        };
        return toString;
    }

    private static TriFunctionThrowable.TriFunction<Object, Object, Integer, Boolean> getExceptionWithMapping(TriConsumerThrowable<Object, Integer, Object> toElementSetter, Function<Object, Object> elementConverter) {
        if (elementConverter == returnsSelf || elementConverter == null) {
            return (fromArray, toArray, index) -> {
                try {
                    Object fromElement = Array.get(fromArray, index);
                    toElementSetter.accept(toArray, (Integer)index, fromElement);
                    return false;
                }
                catch (Exception ex) {
                    return true;
                }
            };
        }
        return (fromArray, toArray, index) -> {
            try {
                Object fromElement = Array.get(fromArray, index);
                toElementSetter.accept(toArray, (Integer)index, elementConverter.apply(fromElement));
                return false;
            }
            catch (Exception ex) {
                return true;
            }
        };
    }

    private static int[] mergeOfInts(int[] fromRoot, int ... selfIndexes) {
        int fromLength = fromRoot.length;
        int selfLength = selfIndexes.length;
        int[] fullPath = Arrays.copyOfRange(fromRoot, 0, fromLength + selfLength);
        for (int i = 0; i < selfLength; ++i) {
            fullPath[fromLength + i] = selfIndexes[i];
        }
        return fullPath;
    }

    public static Object getElement(Object object, int index) {
        Asserts.assertAllTrue(object != null, index >= 0);
        if (object.getClass().isArray()) {
            int length = Array.getLength(object);
            if (index >= length) {
                throw new IllegalArgumentException("Invalid index " + index + " of array with length " + length);
            }
            return Array.get(object, index);
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            int size = collection.size();
            if (index >= size) {
                throw new IllegalArgumentException("Invalid index " + index + " of Collection with size " + size);
            }
            Iterator iterator = collection.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (i++ != index) continue;
                return next;
            }
        }
        throw new IllegalStateException("Fail to get element of " + TypeHelper.deepToString(object) + " at index " + index);
    }

    public static Object getDeepElement(Object object, int[] deepIndex) {
        Asserts.assertAllTrue(deepIndex != null, new boolean[0]);
        int deepIndexLength = deepIndex.length;
        if (deepIndexLength == 0 || deepIndex[0] < 0) {
            return object;
        }
        Object child = TypeHelper.getElement(object, deepIndex[0]);
        int[] childIndex = (int[])TypeHelper.copyOfRange(deepIndex, 1, deepIndexLength);
        return TypeHelper.getDeepElement(child, childIndex);
    }

    public static int[][] getDeepIndexes(Object object) {
        return TypeHelper.getDeepIndexes0(object, new int[0]);
    }

    private static int[][] getDeepIndexes0(Object object, int[] indexes) {
        if (object == null) {
            return new int[][]{TypeHelper.mergeOfInts(indexes, -1)};
        }
        if (object.getClass().isArray()) {
            int length = Array.getLength(object);
            if (length == 0) {
                return new int[][]{TypeHelper.mergeOfInts(indexes, EMPTY_ARRAY_NODE)};
            }
            SimpleTypedList list = new SimpleTypedList((E[])new int[0][]);
            int i = 0;
            while (i < length) {
                Object element = Array.get(object, i);
                int[][] positions = TypeHelper.getDeepIndexes0(element, TypeHelper.mergeOfInts(indexes, i++));
                list.appendAll((E[])positions);
            }
            return (int[][])list.toArray((T[])new int[0][]);
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            int size = collection.size();
            if (size == 0) {
                return new int[][]{TypeHelper.mergeOfInts(indexes, EMPTY_COLLECTION_NODE)};
            }
            SimpleTypedList list = new SimpleTypedList((E[])new int[0][]);
            Iterator iterator = collection.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                Object element = iterator.next();
                int[][] positions = TypeHelper.getDeepIndexes0(element, TypeHelper.mergeOfInts(indexes, i++));
                list.appendAll((E[])positions);
            }
            return (int[][])list.toArray((T[])new int[0][]);
        }
        return new int[][]{TypeHelper.mergeOfInts(indexes, 0)};
    }

    public static boolean nodeEquals(Object obj1, Object obj2, int[] indexes, EqualityStategy equalityStategy) {
        Asserts.assertAllFalse(obj1 == null, obj2 == null, indexes == null);
        int depth = indexes.length;
        int nodeType = indexes[depth - 1];
        if (nodeType == -1) {
            if (equalityStategy == EqualityStategy.TypeIgnored || equalityStategy == EqualityStategy.EmptyAsNull || depth == 1) {
                return true;
            }
            indexes = (int[])TypeHelper.copyOfRange(indexes, 0, depth - 2);
            Class<?> class1 = TypeHelper.getDeepElement(obj1, indexes).getClass();
            Class<?> class2 = TypeHelper.getDeepElement(obj2, indexes).getClass();
            return equalityStategy == EqualityStategy.SameTypeOnly ? class1.equals(class2) : TypeHelper.canBeAssigned(class1, class2) || TypeHelper.canBeAssigned(class2, class1);
        }
        if (nodeType == EMPTY_ARRAY_NODE) {
            if (equalityStategy == EqualityStategy.TypeIgnored) {
                return true;
            }
            Class<?> class1 = TypeHelper.getDeepElement(obj1, indexes).getClass();
            Class<?> class2 = TypeHelper.getDeepElement(obj2, indexes).getClass();
            return equalityStategy == EqualityStategy.SameTypeOnly ? class1.equals(class2) : TypeHelper.canBeAssigned(class1, class2) || TypeHelper.canBeAssigned(class2, class1);
        }
        if (nodeType == EMPTY_COLLECTION_NODE) {
            return true;
        }
        indexes = (int[])TypeHelper.copyOfRange(indexes, 0, depth - 1);
        Object node1 = TypeHelper.getDeepElement(obj1, indexes);
        Object node2 = TypeHelper.getDeepElement(obj2, indexes);
        return node1.equals(node2);
    }

    static boolean deepValueEquals(Object obj1, Object obj2, int[][] deepIndexes, EqualityStategy equalityStategy) {
        int length = deepIndexes.length;
        if (length < PARALLEL_EVALUATION_THRESHOLD) {
            for (int i2 = 0; i2 < length; ++i2) {
                int[] indexes = deepIndexes[i2];
                if (TypeHelper.nodeEquals(obj1, obj2, indexes, equalityStategy)) continue;
                return false;
            }
            return true;
        }
        boolean allEquals = ((Stream)IntStream.range(0, length).boxed().parallel()).allMatch(i -> TypeHelper.nodeEquals(obj1, obj2, deepIndexes[i], equalityStategy));
        return allEquals;
    }

    static boolean deepEqualsParallel(Object obj1, Object obj2, int[][] deepIndexes, EqualityStategy equalityStategy) {
        int length = deepIndexes.length;
        boolean allEquals = ((Stream)IntStream.range(0, length).boxed().parallel()).allMatch(i -> TypeHelper.nodeEquals(obj1, obj2, deepIndexes[i], equalityStategy));
        return allEquals;
    }

    private static boolean deepEqualsSerial(Object obj1, Object obj2, int[][] deepIndexes, EqualityStategy equalityStategy) {
        for (int[] indexes : deepIndexes) {
            if (TypeHelper.nodeEquals(obj1, obj2, indexes, equalityStategy)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object) == 0;
        }
        return false;
    }

    public static boolean canBeAssigned(Class declaringType, Class actualValueType) {
        Asserts.assertAllNotNull(declaringType, actualValueType);
        declaringType = TypeHelper.isPrimitive(declaringType) != false ? TypeHelper.getEquivalentClass(declaringType) : declaringType;
        Class clazz = actualValueType = TypeHelper.isPrimitive(actualValueType) != false ? TypeHelper.getEquivalentClass(actualValueType) : actualValueType;
        if (declaringType.isAssignableFrom(actualValueType)) {
            return true;
        }
        if (declaringType.isArray() && actualValueType.isArray()) {
            return TypeHelper.canBeAssigned(declaringType.getComponentType(), actualValueType.getComponentType());
        }
        if (declaringType.isArray() || actualValueType.isArray()) {
            return false;
        }
        return false;
    }

    public static Boolean canValueEquals(Object obj1, Object obj2, EqualityStategy equalityStategy) {
        if (obj1 == obj2 || obj1 != null && obj1.equals(obj2)) {
            return true;
        }
        if (equalityStategy == EqualityStategy.EmptyAsNull) {
            if (TypeHelper.isNullOrEmpty(obj1)) {
                return TypeHelper.isNullOrEmpty(obj2);
            }
            if (TypeHelper.isNullOrEmpty(obj2)) {
                return false;
            }
        } else {
            if (obj1 == null || obj2 == null) {
                return false;
            }
            if (equalityStategy == EqualityStategy.SameTypeOnly) {
                if (obj1.getClass() != obj2.getClass()) {
                    return false;
                }
                return null;
            }
        }
        if (equalityStategy == EqualityStategy.BetweenAssignableTypes) {
            Class<?> class2;
            Class<?> class1 = obj1.getClass();
            if (TypeHelper.canBeAssigned(class1, class2 = obj2.getClass()) || TypeHelper.canBeAssigned(class2, class1)) {
                return null;
            }
            return false;
        }
        if (equalityStategy == EqualityStategy.TypeIgnored) {
            boolean isNullOrEmpty1 = TypeHelper.isNullOrEmpty(obj1);
            boolean isNullOrEmpty2 = TypeHelper.isNullOrEmpty(obj2);
            if (isNullOrEmpty1 && isNullOrEmpty2) {
                return true;
            }
            if (isNullOrEmpty1 || isNullOrEmpty2) {
                return false;
            }
            return null;
        }
        return false;
    }

    public static boolean valueEquals(Object obj1, Object obj2, EqualityStategy equalityStategy) {
        int[][] deepIndexes2;
        Boolean simpleEquals = TypeHelper.canValueEquals(obj1, obj2, equalityStategy);
        if (simpleEquals != null) {
            return simpleEquals;
        }
        int[][] deepIndexes1 = TypeHelper.getDeepIndexes(obj1);
        if (!Arrays.deepEquals((Object[])deepIndexes1, (Object[])(deepIndexes2 = TypeHelper.getDeepIndexes(obj2)))) {
            return false;
        }
        return TypeHelper.deepValueEquals(obj1, obj2, deepIndexes1, equalityStategy);
    }

    public static boolean valueEquals(Object obj1, Object obj2) {
        return TypeHelper.valueEquals(obj1, obj2, DEFAULT_EMPTY_EQUALITY);
    }

    public static boolean valueEquals(Object obj1, Object obj2, int[][] deepIndexes1, int[][] deepIndexes2) {
        Asserts.assertAllNotNull(deepIndexes1, deepIndexes2);
        if (!Arrays.deepEquals((Object[])deepIndexes1, (Object[])deepIndexes2)) {
            return false;
        }
        return TypeHelper.deepValueEquals(obj1, obj2, deepIndexes1, DEFAULT_EMPTY_EQUALITY);
    }

    public static boolean valueEqualsParallel(Object obj1, Object obj2, EqualityStategy equalityStategy) {
        int[][] deepIndexes2;
        Boolean singleObjectConverter = TypeHelper.canValueEquals(obj1, obj2, equalityStategy);
        if (singleObjectConverter != null) {
            return singleObjectConverter;
        }
        int[][] deepIndexes1 = TypeHelper.getDeepIndexes(obj1);
        if (!Arrays.deepEquals((Object[])deepIndexes1, (Object[])(deepIndexes2 = TypeHelper.getDeepIndexes(obj2)))) {
            return false;
        }
        return TypeHelper.deepEqualsParallel(obj1, obj2, deepIndexes1, equalityStategy);
    }

    public static boolean valueEqualsParallel(Object obj1, Object obj2) {
        return TypeHelper.valueEqualsParallel(obj1, obj2, DEFAULT_EMPTY_EQUALITY);
    }

    public static boolean valueEqualsParallel(Object obj1, Object obj2, int[][] deepIndexes1, int[][] deepIndexes2) {
        Asserts.assertAllNotNull(deepIndexes1, deepIndexes2);
        if (!Arrays.deepEquals((Object[])deepIndexes1, (Object[])deepIndexes2)) {
            return false;
        }
        return TypeHelper.deepEqualsParallel(obj1, obj2, deepIndexes1, DEFAULT_EMPTY_EQUALITY);
    }

    public static boolean valueEqualsSerial(Object obj1, Object obj2, EqualityStategy equalityStategy) {
        int[][] deepIndexes2;
        Boolean singleObjectConverter = TypeHelper.canValueEquals(obj1, obj2, equalityStategy);
        if (singleObjectConverter != null) {
            return singleObjectConverter;
        }
        int[][] deepIndexes1 = TypeHelper.getDeepIndexes(obj1);
        if (!Arrays.deepEquals((Object[])deepIndexes1, (Object[])(deepIndexes2 = TypeHelper.getDeepIndexes(obj2)))) {
            return false;
        }
        return TypeHelper.deepEqualsSerial(obj1, obj2, deepIndexes1, equalityStategy);
    }

    public static boolean valueEqualsSerial(Object obj1, Object obj2) {
        return TypeHelper.valueEqualsSerial(obj1, obj2, DEFAULT_EMPTY_EQUALITY);
    }

    public static boolean valueEqualsSerially(Object obj1, Object obj2, int[][] deepIndexes1, int[][] deepIndexes2) {
        Asserts.assertAllNotNull(deepIndexes1, deepIndexes2);
        if (!Arrays.deepEquals((Object[])deepIndexes1, (Object[])deepIndexes2)) {
            return false;
        }
        return TypeHelper.deepEqualsSerial(obj1, obj2, deepIndexes1, DEFAULT_EMPTY_EQUALITY);
    }

    protected static ConstantPool getConstantPoolOfClass(Class objectClass) {
        try {
            Method method = TypeHelper._getConstantPool();
            return (ConstantPool)method.invoke((Object)objectClass, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Tuple3<Boolean, Class[], Class> getLambdaGenericInfo(OfThrowable lambda) {
        Class<?> lambdaClass = Asserts.checkNoneNulls(lambda, new Object[0]).getClass();
        ConstantPool constantPool = TypeHelper.getConstantPoolOfClass(lambdaClass);
        if (constantPool == null) {
            return null;
        }
        Method functionInterfaceMethod = null;
        int index = constantPool.getSize();
        while (--index >= 0) {
            try {
                functionInterfaceMethod = (Method)constantPool.getMethodAt(index);
                break;
            }
            catch (Exception exception) {
            }
        }
        Class<?>[] parameterClasses = ((Method)Asserts.checkNotNull(functionInterfaceMethod, "Failed to get the Method instance.")).getParameterTypes();
        int parameterCount = functionInterfaceMethod.getParameterCount();
        Class<?> returnClass = functionInterfaceMethod.getReturnType();
        return Tuple.create(parameterClasses.length == parameterCount, parameterClasses, returnClass);
    }

    public static Class getReturnType(OfThrowable aThrowable) {
        return (Class)lambdaGenericInfoRepository.getThirdValue(aThrowable);
    }

    private static Tuple6<Predicate<Class>, FunctionThrowable<Integer, Object>, Class, TriConsumerThrowable<Object, Integer, Object>, TriFunctionThrowable<Object, Integer, Integer, Object>, Function<Object, String>> makeClassOperators(Class clazz) throws Exception {
        Predicate<Class> cPredicate;
        FunctionThrowable<Integer, Object> arrayFactory = length -> Array.newInstance(clazz, (int)length);
        if (!clazz.isArray()) {
            cPredicate = otherClass -> otherClass != null && clazz.isAssignableFrom((Class<?>)otherClass);
        } else {
            Class<?> componentClass = clazz.getComponentType();
            Predicate<Class> componentPredicate = TypeHelper.getClassEqualitor(componentClass);
            cPredicate = otherClass -> otherClass != null && otherClass.isArray() && componentPredicate.test(otherClass.getComponentType());
        }
        Class<?> arrayClass = arrayFactory.apply(0).getClass();
        TriConsumerThrowable<Object, Integer, Object> setElement = arraySet;
        TriFunctionThrowable<Object, Integer, Integer, Object> copyOfRange = TypeHelper.asGenericCopyOfRange(clazz);
        Function<Object, String> toString = TypeHelper.getDeepToString(clazz);
        return Tuple.create(cPredicate, arrayFactory, arrayClass, setElement, copyOfRange, toString);
    }

    public static Predicate<Class> getClassEqualitor(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return (Predicate)classOperators.getFirstValue(clazz);
    }

    public static boolean areEquivalent(Class class1, Class class2) {
        Asserts.assertAllNotNull(class1, class2);
        return ((Predicate)classOperators.getFirstValue(class1)).test(class2);
    }

    public static FunctionThrowable<Integer, Object> getArrayFactory(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return (FunctionThrowable)classOperators.getSecondValue(clazz);
    }

    public static Class getArrayClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return (Class)classOperators.getThirdValue(clazz);
    }

    public static TriConsumerThrowable<Object, Integer, Object> getArrayElementSetter(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return (TriConsumerThrowable)classOperators.getFourthValue(clazz);
    }

    public static TriFunctionThrowable<Object, Integer, Integer, Object> getArrayRangeCopier(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return (TriFunctionThrowable)classOperators.getFifthValue(clazz);
    }

    public static Object copyOfRange(Object array, int from, int to) {
        try {
            if (array == null) {
                return null;
            }
            Class<?> compoentType = Asserts.checkNotNull(array.getClass().getComponentType(), "failed to get the componentType of given array.");
            TriFunctionThrowable<Object, Integer, Integer, Object> copier = Asserts.checkNotNull(TypeHelper.getArrayRangeCopier(compoentType), "Failed to get ArrayRangeCopier of given array.");
            return copier.apply(array, from, to);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Function<Object, String> getArrayToString(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return (Function)classOperators.getSixthValue(clazz);
    }

    private static Tuple6<Boolean, Object, Class, Function<Object, Object>, Function<Object, Object>, Function<Object, Object>> makeBaseTypeConverters(Class clazz) {
        boolean isArray = clazz.isArray();
        if (!isArray && !clazz.isPrimitive()) {
            return Tuple.create(false, null, OBJECT_CLASS, returnsSelf, returnsSelf, returnsSelf);
        }
        Class<?> componentClass = clazz.getComponentType();
        Boolean isPrimitive = TypeHelper.isPrimitive(componentClass);
        Object defaultValue = EMPTY_ARRAY_AS_DEFAULT ? ArrayHelper.getNewArray(componentClass, 0) : null;
        Class equivalentComponentClass = TypeHelper.getEquivalentClass(componentClass);
        Class equivalentClass = (Class)classOperators.getThirdValue(equivalentComponentClass);
        Function<Object, Object> componentConverter = TypeHelper.getToEquivalentSerialConverter(componentClass);
        TriConsumerThrowable<Object, Integer, Object> equivalentSetter = TypeHelper.getArrayElementSetter(equivalentComponentClass);
        TriFunctionThrowable.TriFunction<Object, Object, Integer, Boolean> getExceptionWhileMapping = TypeHelper.getExceptionWithMapping(equivalentSetter, componentConverter);
        Function<Object, Object> parallelConverter = equivalentClass == null ? returnsSelf : fromArray -> {
            if (fromArray == null) {
                return null;
            }
            int length = Array.getLength(fromArray);
            Object toArray = ArrayHelper.getNewArray(equivalentComponentClass, length);
            Optional<Integer> firstExceptionIndex = ((Stream)IntStream.range(0, length).boxed().parallel()).filter(i -> (Boolean)getExceptionWhileMapping.apply(fromArray, toArray, (Integer)i)).findFirst();
            return firstExceptionIndex.isPresent() ? null : toArray;
        };
        Function<Object, Object> serialConverter = equivalentClass == null ? returnsSelf : fromArray -> {
            if (fromArray == null) {
                return null;
            }
            int length = Array.getLength(fromArray);
            Object toArray = ArrayHelper.getNewArray(equivalentComponentClass, length);
            try {
                for (int i = 0; i < length; ++i) {
                    Object fromElement = Array.get(fromArray, i);
                    equivalentSetter.accept(toArray, i, componentConverter.apply(fromElement));
                }
                return toArray;
            }
            catch (Exception ex) {
                return null;
            }
        };
        Function<Object, Object> defaultConverterr = equivalentClass == null ? returnsSelf : fromArray -> {
            if (fromArray == null) {
                return null;
            }
            int length = Array.getLength(fromArray);
            Object toArray = ArrayHelper.getNewArray(equivalentComponentClass, length);
            if (length < PARALLEL_EVALUATION_THRESHOLD) {
                try {
                    for (int i2 = 0; i2 < length; ++i2) {
                        Object fromElement = Array.get(fromArray, i2);
                        equivalentSetter.accept(toArray, i2, componentConverter.apply(fromElement));
                    }
                    return toArray;
                }
                catch (Exception ex) {
                    return null;
                }
            }
            Optional<Integer> firstExceptionIndex = ((Stream)IntStream.range(0, length).boxed().parallel()).filter(i -> (Boolean)getExceptionWhileMapping.apply(fromArray, toArray, (Integer)i)).findFirst();
            return firstExceptionIndex.isPresent() ? null : toArray;
        };
        return Tuple.create(isPrimitive, defaultValue, equivalentClass, parallelConverter, serialConverter, defaultConverterr);
    }

    public static Boolean isPrimitive(Class clazz) {
        Boolean result = (Boolean)baseTypeConverters.getFirstValue(Asserts.checkNoneNulls(clazz, new Object[0]));
        return result == null ? false : result;
    }

    public static Object getDefaultValue(Class clazz) {
        return baseTypeConverters.getSecondValue(Asserts.checkNoneNulls(clazz, new Object[0]));
    }

    public static Class getEquivalentClass(Class clazz) {
        return (Class)baseTypeConverters.getThirdValue(Asserts.checkNoneNulls(clazz, new Object[0]));
    }

    public static Function<Object, Object> getToEquivalentParallelConverter(Class clazz) {
        return (Function)baseTypeConverters.getFourthValue(Asserts.checkNoneNulls(clazz, new Object[0]));
    }

    public static Function<Object, Object> getToEquivalentSerialConverter(Class clazz) {
        return (Function)baseTypeConverters.getFifthValue(Asserts.checkNoneNulls(clazz, new Object[0]));
    }

    public static Function<Object, Object> getToEquivalentConverter(Class clazz) {
        return (Function)baseTypeConverters.getSixthValue(Asserts.checkNoneNulls(clazz, new Object[0]));
    }

    public static Object toEquivalent(Object obj) {
        if (obj == null) {
            return null;
        }
        return TypeHelper.getToEquivalentConverter(obj.getClass()).apply(obj);
    }

    private static Map<Tuple2<Class, Class>, Tuple3<Function<Object, Object>, Function<Object, Object>, Function<Object, Object>>> getConverterMap() {
        return new HashMap<Tuple2<Class, Class>, Tuple3<Function<Object, Object>, Function<Object, Object>, Function<Object, Object>>>();
    }

    private static Tuple3<Function<Object, Object>, Function<Object, Object>, Function<Object, Object>> getDeepEvaluators(Class fromClass, Class toClass) {
        boolean needConversion;
        Class<?> toComponentClass;
        Asserts.assertAllNotNull(fromClass, toClass);
        boolean isFromArray = fromClass.isArray();
        boolean isToArray = toClass.isArray();
        if (!isFromArray && !isToArray) {
            if (TypeHelper.valueEquals(fromClass, toClass)) {
                return Tuple.create(returnsSelf, returnsSelf, returnsSelf);
            }
            if (TypeHelper.valueEquals(TypeHelper.getEquivalentClass(fromClass), toClass)) {
                Function<Object, Object> singleObjectConverter = TypeHelper.getToEquivalentConverter(fromClass);
                return Tuple.create(singleObjectConverter, singleObjectConverter, singleObjectConverter);
            }
            if (toClass.isAssignableFrom(fromClass)) {
                Function<Object, Object> singleObjectConverter = returnsSelf;
                return Tuple.create(singleObjectConverter, singleObjectConverter, singleObjectConverter);
            }
            if (fromClass.isAssignableFrom(toClass)) {
                Function<Object, Object> singleObjectConverter = toClass::cast;
                return Tuple.create(singleObjectConverter, singleObjectConverter, singleObjectConverter);
            }
            return Tuple.create(mapsToNull, mapsToNull, mapsToNull);
        }
        if (!isToArray) {
            return toClass.isAssignableFrom(fromClass) ? Tuple.create(returnsSelf, returnsSelf, returnsSelf) : Tuple.create(mapsToNull, mapsToNull, mapsToNull);
        }
        if (!isFromArray) {
            return Tuple.create(mapsToNull, mapsToNull, mapsToNull);
        }
        Class<?> fromComponentClass = fromClass.getComponentType();
        if (fromComponentClass.equals(toComponentClass = toClass.getComponentType())) {
            return Tuple.create(returnsSelf, returnsSelf, returnsSelf);
        }
        boolean bl = needConversion = fromComponentClass.isPrimitive() != toComponentClass.isPrimitive();
        if (needConversion) {
            Class equivalentFromComponentType = TypeHelper.getEquivalentClass(fromComponentClass);
            Class equivalentToComponentType = TypeHelper.getEquivalentClass(toComponentClass);
            if (!toComponentClass.isAssignableFrom(equivalentFromComponentType) && !fromComponentClass.isAssignableFrom(equivalentToComponentType)) {
                return Tuple.create(mapsToNull, mapsToNull, mapsToNull);
            }
        } else if (!fromComponentClass.isAssignableFrom(toComponentClass) && !toComponentClass.isAssignableFrom(fromComponentClass)) {
            return Tuple.create(mapsToNull, mapsToNull, mapsToNull);
        }
        FunctionThrowable<Integer, Object> factory = TypeHelper.getArrayFactory(toComponentClass);
        TriConsumerThrowable<Object, Integer, Object> toElementSetter = TypeHelper.getArrayElementSetter(toComponentClass);
        Function<Object, Object> elementConverter = needConversion ? TypeHelper.getToEquivalentSerialConverter(fromComponentClass) : returnsSelf;
        TriFunctionThrowable.TriFunction<Object, Object, Integer, Boolean> elementMappingWithException = TypeHelper.getExceptionWithMapping(toElementSetter, elementConverter);
        Function<Object, Object> parallelConverter = fromArray -> {
            if (fromArray == null) {
                return null;
            }
            try {
                int length = Array.getLength(fromArray);
                Object toArray = factory.apply(length);
                Integer firstIndexWithException = ((Stream)IntStream.range(0, length).boxed().parallel()).filter(i -> (Boolean)elementMappingWithException.apply(fromArray, toArray, (Integer)i)).findFirst().orElse(-1);
                return firstIndexWithException == -1 ? toArray : null;
            }
            catch (Exception ex) {
                return null;
            }
        };
        Function<Object, Object> serialConverter = fromArray -> {
            if (fromArray == null) {
                return null;
            }
            try {
                int length = Array.getLength(fromArray);
                Object toArray = factory.apply(length);
                for (int i = 0; i < length; ++i) {
                    Object fromElement = Array.get(fromArray, i);
                    Object convertedElement = elementConverter.apply(fromElement);
                    toElementSetter.accept(toArray, i, convertedElement);
                }
                return toArray;
            }
            catch (Exception ex) {
                return null;
            }
        };
        Function<Object, Object> defaultConverter = fromArray -> {
            if (fromArray == null) {
                return null;
            }
            int length = Array.getLength(fromArray);
            try {
                Object toArray = factory.apply(length);
                if (length < PARALLEL_EVALUATION_THRESHOLD) {
                    for (int i2 = 0; i2 < length; ++i2) {
                        Object fromElement = Array.get(fromArray, i2);
                        Object convertedElement = elementConverter.apply(fromElement);
                        toElementSetter.accept(toArray, i2, convertedElement);
                    }
                    return toArray;
                }
                Integer firstIndexWithException = ((Stream)IntStream.range(0, length).boxed().parallel()).filter(i -> (Boolean)elementMappingWithException.apply(fromArray, toArray, (Integer)i)).findFirst().orElse(-1);
                return firstIndexWithException == -1 ? toArray : null;
            }
            catch (Exception ex) {
                return null;
            }
        };
        return Tuple.create(parallelConverter, serialConverter, defaultConverter);
    }

    public static <T> T convertParallel(Object obj, Class<T> toClass) {
        if (obj == null) {
            return null;
        }
        Class<?> fromClass = obj.getClass();
        Function converter = (Function)deepConverters.getFirst(fromClass, toClass);
        return (T)converter.apply(obj);
    }

    public static <T> T convertSerial(Object obj, Class<T> toClass) {
        if (obj == null) {
            return null;
        }
        Class<?> fromClass = obj.getClass();
        Function converter = (Function)deepConverters.getSecond(fromClass, toClass);
        return (T)converter.apply(obj);
    }

    public static <T> T convert(Object obj, Class<T> toClass) {
        if (obj == null) {
            return null;
        }
        Class<?> fromClass = obj.getClass();
        Function converter = (Function)deepConverters.getThird(fromClass, toClass);
        return (T)converter.apply(obj);
    }

    public static int deepHashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Collection) {
            if (((Collection)obj).size() == 0) {
                return 37;
            }
        } else if (obj.getClass().isArray()) {
            if (Array.getLength(obj) == 0) {
                return 37;
            }
        } else {
            return obj.hashCode();
        }
        int result = 1;
        int[][] deepIndexes = TypeHelper.getDeepIndexes(obj);
        for (int i = 0; i < deepIndexes.length; ++i) {
            int[] deepIndex = deepIndexes[i];
            int[] childDeepIndex = Asserts.checkNotNull((int[])TypeHelper.copyOfRange(deepIndex, 0, deepIndex.length - 1), "Failed to copy range");
            Object element = TypeHelper.getDeepElement(obj, childDeepIndex);
            int elementHash = TypeHelper.deepHashCode(element);
            result = 31 * result + elementHash;
        }
        return result;
    }

    public static String deepToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            List elementStrings = IntStream.range(0, collection.size()).mapToObj(i -> TypeHelper.deepToString(TypeHelper.getElement(obj, i))).collect(Collectors.toList());
            return "[" + String.join((CharSequence)", ", elementStrings) + "]";
        }
        if (obj.getClass().isArray()) {
            Function<Object, String> arrayToString = Asserts.checkNotNull(TypeHelper.getArrayToString(obj.getClass().getComponentType()), "failed to get arrayToString");
            return arrayToString.apply(obj);
        }
        return obj.toString();
    }

    public static enum EqualityStategy {
        EmptyAsNull,
        TypeIgnored,
        BetweenAssignableTypes,
        SameTypeOnly;

    }
}

