/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.Range;
import io.github.cruisoring.throwables.PredicateThrowable;
import io.github.cruisoring.utility.ReadOnlyList;
import java.util.List;
import java.util.stream.IntStream;

public interface TypedList<E>
extends List<E> {
    public Class<? extends E> getElementType();

    public int removeByIndexes(Integer ... var1);

    public boolean insertAll(int var1, E ... var2);

    public boolean appendAll(E ... var1);

    public ReadOnlyList<E> asReadOnly();

    default public Integer[] matchedIndexes(PredicateThrowable<E> elementPredicate) {
        Asserts.assertNotNull(elementPredicate, "The elementPredicate must be supplied.");
        Integer[] indexes = (Integer[])IntStream.range(0, this.size()).filter(i -> elementPredicate.orElse(false).test(this.get(i))).boxed().toArray(Integer[]::new);
        return indexes;
    }

    default public boolean removeAllMatched(PredicateThrowable<E> predicate) {
        Integer[] indexes = this.matchedIndexes(predicate);
        return this.removeByIndexes(indexes) > 0;
    }

    default public boolean retainAllMatched(PredicateThrowable<E> predicate) {
        Integer[] indexes = this.matchedIndexes(predicate.reversed());
        return this.removeByIndexes(indexes) > 0;
    }

    default public List<E> subList(Range range) {
        Asserts.assertNotNull(range, "Range must be used to specify the fromIndex and toIndex to get subList");
        return this.subList(range.getStartInclusive(), range.getEndExclusive());
    }
}

