/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.logger;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.logger.IWithColor;
import io.github.cruisoring.logger.LogLevel;
import io.github.cruisoring.logger.Logger;
import io.github.cruisoring.utility.StringHelper;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class ConsoleLogger
extends Logger
implements IWithColor {
    static final String ARGUMENT_REGEX = "%(\\d*$)?(\\d*)?\\S";
    public static final String RESET = "\u001b[0m";
    public static final String BLACK = "\u001b[0;30m";
    public static final String RED = "\u001b[0;31m";
    public static final String GREEN = "\u001b[0;32m";
    public static final String YELLOW = "\u001b[0;33m";
    public static final String BLUE = "\u001b[0;34m";
    public static final String PURPLE = "\u001b[0;35m";
    public static final String CYAN = "\u001b[0;36m";
    public static final String WHITE = "\u001b[0;37m";
    public static final String BLACK_BOLD = "\u001b[1;30m";
    public static final String RED_BOLD = "\u001b[1;31m";
    public static final String GREEN_BOLD = "\u001b[1;32m";
    public static final String YELLOW_BOLD = "\u001b[1;33m";
    public static final String BLUE_BOLD = "\u001b[1;34m";
    public static final String PURPLE_BOLD = "\u001b[1;35m";
    public static final String CYAN_BOLD = "\u001b[1;36m";
    public static final String WHITE_BOLD = "\u001b[1;37m";
    public static final String BLACK_UNDERLINED = "\u001b[4;30m";
    public static final String RED_UNDERLINED = "\u001b[4;31m";
    public static final String GREEN_UNDERLINED = "\u001b[4;32m";
    public static final String YELLOW_UNDERLINED = "\u001b[4;33m";
    public static final String BLUE_UNDERLINED = "\u001b[4;34m";
    public static final String PURPLE_UNDERLINED = "\u001b[4;35m";
    public static final String CYAN_UNDERLINED = "\u001b[4;36m";
    public static final String WHITE_UNDERLINED = "\u001b[4;37m";
    public static final String BLACK_BACKGROUND = "\u001b[40m";
    public static final String DARK_GRAY_BACKGROUND = "\u001b[100m";
    public static final String RED_BACKGROUND = "\u001b[101m";
    public static final String GREEN_BACKGROUND = "\u001b[102m";
    public static final String YELLOW_BACKGROUND = "\u001b[103m";
    public static final String BLUE_BACKGROUND = "\u001b[104m";
    public static final String PURPLE_BACKGROUND = "\u001b[105m";
    public static final String CYAN_BACKGROUND = "\u001b[106m";
    public static final String WHITE_BACKGROUND = "\u001b[107m";
    public static final String DEFAULT_FAIL_PLACEHOLDER = "\u001b[1;31m$0\u001b[0m";
    public static final String DEFAULT_SUCCESS_PLACEHOLDER = "\u001b[1;32m$0\u001b[0m";
    public static final String DEFAULT_NORMAL_PLACEHOLDER = "\u001b[1;34m$0\u001b[0m";
    static final Map<LogLevel, String> levelColors = new HashMap<LogLevel, String>(){
        {
            this.put(LogLevel.verbose, "\u001b[107m\u001b[0;30m");
            this.put(LogLevel.debug, ConsoleLogger.PURPLE_UNDERLINED);
            this.put(LogLevel.info, "\u001b[106m\u001b[0;30m");
            this.put(LogLevel.warning, "\u001b[103m\u001b[4;35m");
            this.put(LogLevel.error, "\u001b[101m\u001b[1;30m");
            this.put(LogLevel.none, "");
        }
    };

    public ConsoleLogger(Consumer<String> recorder, LogLevel concernedLevel) {
        super(recorder, concernedLevel);
    }

    public ConsoleLogger(Consumer<String> recorder) {
        this(recorder, LogLevel.verbose);
    }

    @Override
    public String failPlaceholder() {
        return DEFAULT_FAIL_PLACEHOLDER;
    }

    @Override
    public String successPlaceholder() {
        return DEFAULT_SUCCESS_PLACEHOLDER;
    }

    @Override
    public String normalPlaceholder() {
        return DEFAULT_NORMAL_PLACEHOLDER;
    }

    @Override
    public String highlightArgs(String format) {
        String highlighted = this.isSuccess(format) ? format.replaceAll(ARGUMENT_REGEX, DEFAULT_SUCCESS_PLACEHOLDER) : (this.isFailed(format) ? format.replaceAll(ARGUMENT_REGEX, DEFAULT_FAIL_PLACEHOLDER) : format.replaceAll(ARGUMENT_REGEX, DEFAULT_NORMAL_PLACEHOLDER));
        return highlighted;
    }

    @Override
    public String getMessage(LogLevel level, String format, Object ... args) {
        Asserts.assertAllNotNull(format, new String[0]);
        String label = String.format("[%s%s]:", level.label, DefaultTimeStampFormatter == null ? "" : "@" + LocalDateTime.now().format(DefaultTimeStampFormatter));
        String message = levelColors.get((Object)level) + label + RESET;
        if (args != null && args.length == 0) {
            message = message + " " + format;
            return message;
        }
        String highlighted = this.highlightArgs(format);
        message = message + " " + StringHelper.tryFormatString(highlighted, args);
        return message;
    }
}

