/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.logger;

import io.github.cruisoring.Lazy;
import io.github.cruisoring.logger.LogLevel;
import io.github.cruisoring.logger.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.function.Consumer;

public class FileLogger
extends Logger
implements AutoCloseable {
    public static final String NEW_LINE = "\r\n";
    static final Consumer<String> _do_nothing = s -> {};
    final File file;
    boolean isValid = true;
    final Lazy<FileWriter> fileWriterLazy;
    final Lazy<BufferedWriter> bufferedWriterLazy;

    public FileLogger(String filePath, LogLevel minLevel) {
        super(_do_nothing, minLevel);
        this.file = FileLogger.getFile(filePath);
        this.fileWriterLazy = new Lazy<FileWriter>(() -> new FileWriter(this.file, true));
        this.bufferedWriterLazy = this.fileWriterLazy.create(BufferedWriter::new);
    }

    public FileLogger(String filePath) {
        this(filePath, LogLevel.verbose);
    }

    static File getFile(String filePath) {
        if (filePath == null) {
            return null;
        }
        return new File(Paths.get(filePath, new String[0]).toString());
    }

    @Override
    public String toString() {
        return String.format("FileLogger of %s or above with '%s'", new Object[]{this.minLevel, this.file});
    }

    @Override
    public boolean canLog(LogLevel level) {
        if (!this.isValid || !super.canLog(level)) {
            return false;
        }
        return this.bufferedWriterLazy.getValue() != null;
    }

    @Override
    public void save(String message) {
        if (!this.isValid) {
            return;
        }
        try {
            BufferedWriter bufferedWriter = this.bufferedWriterLazy.getValue();
            bufferedWriter.write(message + NEW_LINE);
            bufferedWriter.flush();
        }
        catch (IOException e) {
            this.isValid = false;
        }
    }

    @Override
    public void close() throws Exception {
        this.fileWriterLazy.close();
    }
}

