/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.table;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.TypeHelper;
import io.github.cruisoring.logger.Logger;
import io.github.cruisoring.table.IColumns;
import io.github.cruisoring.table.ITable;
import io.github.cruisoring.table.TupleRow;
import io.github.cruisoring.table.WithValuesByName;
import io.github.cruisoring.throwables.FunctionThrowable;
import io.github.cruisoring.throwables.PredicateThrowable;
import io.github.cruisoring.tuple.Tuple;
import io.github.cruisoring.tuple.WithValues;
import io.github.cruisoring.utility.ArrayHelper;
import io.github.cruisoring.utility.SimpleTypedList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class TupleTable<R extends WithValues>
implements ITable<R> {
    final IColumns columns;
    final List<WithValues> rows;
    final Class[] elementTypes;

    protected TupleTable(Supplier<List<WithValues>> rowsSupplier, IColumns columns, Class ... elementTypes) {
        this.columns = Asserts.checkNoneNulls(columns, elementTypes);
        this.rows = rowsSupplier == null ? new SimpleTypedList<WithValues>(new WithValues[0]) : rowsSupplier.get();
        this.elementTypes = elementTypes;
    }

    protected TupleTable(IColumns columns, Class ... elementTypes) {
        this(null, columns, elementTypes);
    }

    @Override
    public IColumns getColumns() {
        return this.columns;
    }

    @Override
    public int getColumnIndex(String columnName) {
        return this.columns.get(columnName);
    }

    @Override
    public Collection<String> getDisplayedNames() {
        return this.columns.getColumnNames();
    }

    @Override
    public int width() {
        return this.elementTypes.length;
    }

    @Override
    public Class[] getElementTypes() {
        return this.elementTypes;
    }

    @Override
    public WithValuesByName getRow(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.rows.size()) {
            return null;
        }
        return this.columns.asRow(this.rows.get(rowIndex));
    }

    @Override
    public WithValuesByName getRow(Map<String, Object> valuesByName) {
        int index = this.indexOf(Asserts.checkNoneNulls(valuesByName, new Object[0]));
        return this.getRow(index);
    }

    @Override
    public WithValuesByName getRow(int rowIndex, IColumns viewColumns) {
        if (rowIndex < 0 || rowIndex >= this.rows.size()) {
            return null;
        }
        WithValues<Integer> mappedIndex = Asserts.checkNoneNulls(viewColumns, new Object[0]).mapIndexes(this.getColumns());
        if (mappedIndex.anyMatch(Objects::isNull)) {
            return null;
        }
        WithValues row = this.rows.get(rowIndex);
        Object[] viewElements = (Object[])ArrayHelper.create(Object.class, mappedIndex.getLength(), i -> row.getValue((Integer)mappedIndex.getValue((int)i)));
        Tuple<Object> tuple = Tuple.setOf(viewElements);
        return new TupleRow(viewColumns, tuple);
    }

    @Override
    public WithValuesByName[] getAllRows() {
        WithValuesByName[] namedRows = (WithValuesByName[])ArrayHelper.create(WithValuesByName.class, this.size(), i -> new TupleRow(this.columns, this.rows.get((int)i)));
        return namedRows;
    }

    @Override
    public WithValuesByName[] getAllRows(Map<String, PredicateThrowable> expectedConditions) {
        WithValuesByName[] matchedRows = (WithValuesByName[])this.streamOfRows(expectedConditions).toArray(WithValuesByName[]::new);
        return matchedRows;
    }

    @Override
    public Stream<WithValuesByName> streamOfRows(Map<String, PredicateThrowable> expectedConditions) {
        Asserts.checkNoneNulls(expectedConditions, new Object[0]);
        if (expectedConditions.isEmpty()) {
            throw new IllegalArgumentException("No expections specified.");
        }
        Map<Integer, String> map = this.getIndexedNames(expectedConditions.keySet());
        Map<Integer, PredicateThrowable> indexedPredicates = map.entrySet().stream().collect(Collectors.toMap(entry -> (Integer)entry.getKey(), entry -> (PredicateThrowable)expectedConditions.get(entry.getValue())));
        Stream<WithValuesByName> matchedRows = this.rows.stream().filter(row -> row.meetConditions(indexedPredicates)).map(row -> new TupleRow(this.columns, (WithValues)row));
        return matchedRows;
    }

    @Override
    public ITable getView(IColumns viewColumns) {
        Asserts.assertAllNotNull(viewColumns, new IColumns[0]);
        WithValues<Integer> mappedIndex = viewColumns.mapIndexes(this.getColumns());
        if (mappedIndex.anyMatch(Objects::isNull)) {
            return null;
        }
        Integer[] indexes = (Integer[])IntStream.range(0, mappedIndex.getLength()).boxed().map(i -> (Integer)mappedIndex.getValue((int)i)).toArray(Integer[]::new);
        Class[] eTypes = (Class[])Arrays.stream(indexes).map(i -> this.elementTypes[i]).toArray(Class[]::new);
        TupleTable<R> table = new TupleTable<R>(viewColumns, eTypes);
        int size = this.rows.size();
        int width = indexes.length;
        for (int i2 = 0; i2 < size; ++i2) {
            WithValues row = this.rows.get(i2);
            Object[] elements = (Object[])ArrayHelper.create(Object.class, width, vIndex -> row.getValue(indexes[vIndex]));
            table.rows.add(Tuple.of(elements));
        }
        return table;
    }

    @Override
    public boolean replace(WithValuesByName row, Map<String, Object> newValues) {
        Asserts.assertAllNotNull(row, newValues);
        int index = this.indexOf(row);
        if (index < 0 || newValues.isEmpty()) {
            return false;
        }
        try {
            WithValues tuple = this.rows.get(index);
            Map<Integer, String> indexedNames = this.getIndexedNames(newValues.keySet());
            Object[] elements = (Object[])ArrayHelper.create(Object.class, tuple.getLength(), i -> indexedNames.containsKey(i) ? newValues.get(indexedNames.get(i)) : tuple.getValue((int)i));
            Tuple replacement = Tuple.of(elements);
            this.rows.remove(index);
            this.rows.add(index, replacement);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Override
    public boolean update(WithValuesByName row, Map<String, FunctionThrowable<WithValuesByName, Object>> valueSuppliers) {
        Asserts.assertAllNotNull(row, valueSuppliers);
        int index = this.indexOf(row);
        if (index < 0) {
            return false;
        }
        try {
            WithValuesByName oldRow = this.getRow(index);
            Map<Integer, String> indexedNames = this.getIndexedNames(valueSuppliers.keySet());
            Object[] elements = (Object[])ArrayHelper.create(Object.class, row.getLength(), i -> indexedNames.containsKey(i) ? ((FunctionThrowable)valueSuppliers.get(indexedNames.get(i))).orElse(null).apply(oldRow) : oldRow.getValue((int)i));
            Tuple replacement = Tuple.of(elements);
            this.rows.remove(index);
            this.rows.add(index, replacement);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Override
    public int updateAll(Stream<WithValuesByName> rowsToBeUpdate, Map<String, FunctionThrowable<WithValuesByName, Object>> valueSuppliers) {
        int index;
        Asserts.assertAllNotNull(rowsToBeUpdate, valueSuppliers);
        Map<Integer, String> indexedNames = this.getIndexedNames(valueSuppliers.keySet());
        HashMap<Integer, Tuple> replacements = new HashMap<Integer, Tuple>();
        for (WithValuesByName withValuesByName : rowsToBeUpdate::iterator) {
            index = this.indexOf(withValuesByName);
            if (index == -1) continue;
            WithValues oldRow = this.rows.get(index);
            Object[] elements = (Object[])ArrayHelper.create(Object.class, oldRow.getLength(), i -> indexedNames.containsKey(i) ? ((FunctionThrowable)valueSuppliers.get(indexedNames.get(i))).orElse(null).apply(row) : oldRow.getValue((int)i));
            replacements.put(index, Tuple.of(elements));
        }
        for (Map.Entry entry : replacements.entrySet()) {
            index = (Integer)entry.getKey();
            this.rows.remove(index);
            this.rows.add(index, (WithValues)entry.getValue());
        }
        return replacements.size();
    }

    @Override
    public boolean add(WithValuesByName row) {
        if (row == null) {
            return false;
        }
        if (row.getColumnIndexes() == this.columns) {
            return this.addValues(row.getValues());
        }
        WithValues<Integer> mappedIndexes = this.columns.mapIndexes(row.getColumnIndexes());
        if (mappedIndexes.anyMatch(Objects::isNull)) {
            return false;
        }
        int _width = this.width();
        for (int i = 0; i < _width; ++i) {
            int position = mappedIndexes.getValue(i);
            Object value = row.getValue(position);
            Class expectedType = this.elementTypes[i];
            if (value == null || value.getClass().isAssignableFrom(expectedType)) continue;
            Logger.V("The value '%s' at position %d is not assignable from %s", value.toString(), position, expectedType.getSimpleName());
            return false;
        }
        return false;
    }

    @Override
    public boolean addValues(Map<String, Object> valuesByName) {
        if (valuesByName == null) {
            return false;
        }
        Map<Integer, String> indexedNames = this.getIndexedNames(valuesByName.keySet());
        int length = this.width() > this.columns.width() ? this.width() : this.columns.width();
        Object[] values = IntStream.range(0, length).boxed().map(i -> indexedNames.containsKey(i) ? valuesByName.get(indexedNames.get(i)) : null).toArray();
        Tuple row = Tuple.of(values);
        return this.addValues(row);
    }

    @Override
    public boolean addValues(WithValues rowValues) {
        int _width = this.width();
        if (rowValues == null || rowValues.getLength() < this.width()) {
            return false;
        }
        for (int i = 0; i < _width; ++i) {
            Object value = rowValues.getValue(i);
            Class expectedType = this.elementTypes[i];
            if (value == null || value.getClass().isAssignableFrom(expectedType)) continue;
            Logger.V("The value '%s' at position %d is not assignable from %s", value.toString(), i, expectedType.getSimpleName());
            return false;
        }
        return this.rows.add(rowValues);
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o == null || !(o instanceof WithValues)) {
            return false;
        }
        if (o instanceof WithValuesByName) {
            WithValuesByName other = (WithValuesByName)o;
            if (other.getColumnIndexes() == this.columns) {
                return this.rows.contains(other.getValues());
            }
            WithValues<Integer> mappedIndexes = this.columns.mapIndexes(other.getColumnIndexes());
            if (mappedIndexes.anyMatch(Objects::isNull)) {
                return false;
            }
            Object[] elements = IntStream.range(0, this.width()).boxed().map(i -> (Integer)mappedIndexes.getValue((int)i)).map(i -> other.getValue((int)i)).toArray();
            return this.rows.contains(Tuple.of(elements));
        }
        return this.rows.contains(((WithValues)o).getValues());
    }

    @Override
    public int indexOf(WithValuesByName row) {
        if (row == null) {
            return -1;
        }
        IColumns rowColumns = row.getColumnIndexes();
        if (rowColumns == this.columns) {
            return this.rows.indexOf(row.getValues());
        }
        WithValues<Integer> mappedIndexes = this.columns.mapIndexes(rowColumns);
        if (mappedIndexes.anyMatch(Objects::isNull)) {
            return -1;
        }
        Object[] elements = IntStream.range(0, this.width()).boxed().map(i -> (Integer)mappedIndexes.getValue((int)i)).map(i -> row.getValue((int)i)).toArray();
        Tuple values = Tuple.of(elements);
        return this.rows.indexOf(values);
    }

    @Override
    public int indexOf(Map<String, Object> valuesByName) {
        Map<Integer, String> map = this.getIndexedNames(valuesByName.keySet());
        Map<Integer, Object> expectedValues = map.entrySet().stream().collect(Collectors.toMap(entry -> (Integer)entry.getKey(), entry -> valuesByName.get(entry.getValue())));
        for (int i = 0; i < this.size(); ++i) {
            if (!this.rows.get(i).isMatched(expectedValues)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Iterator<WithValuesByName> iterator() {
        Stream<WithValuesByName> stream = this.rows.stream().map(v -> new TupleRow(this.columns, (WithValues)v));
        return stream.iterator();
    }

    public String toString() {
        return this.isEmpty() ? this.columns.toString() : TypeHelper.deepToString(this.rows);
    }

    @Override
    public Object[] toArray() {
        return this.rows.stream().map(v -> new TupleRow(this.columns, (WithValues)v)).toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Class componentClass = ArrayHelper.getComponentType(a);
        if (componentClass.isAssignableFrom(WithValuesByName.class) || WithValuesByName.class.isAssignableFrom(componentClass)) {
            return (Object[])TypeHelper.convert(this.toArray(), a.getClass());
        }
        if (componentClass.isAssignableFrom(WithValues.class) || WithValues.class.isAssignableFrom(componentClass)) {
            return (Object[])TypeHelper.convert(this.rows.toArray(), a.getClass());
        }
        return null;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null || !(o instanceof WithValues)) {
            return false;
        }
        if (o instanceof WithValuesByName) {
            WithValuesByName other = (WithValuesByName)o;
            if (other.getColumnIndexes() == this.columns) {
                return this.rows.remove(other.getValues());
            }
            WithValues<Integer> mappedIndexes = this.columns.mapIndexes(other.getColumnIndexes());
            if (mappedIndexes.anyMatch(Objects::isNull)) {
                return false;
            }
            Object[] elements = IntStream.range(0, this.width()).boxed().map(mappedIndexes::getValue).map(i -> other.getValue((int)i)).toArray();
            Tuple row = Tuple.of(elements);
            return this.rows.contains(row) && this.rows.remove(row);
        }
        return this.rows.remove(((WithValues)o).getValues());
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends WithValuesByName> c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        boolean added = false;
        for (WithValuesByName withValuesByName : c) {
            if (!this.add(withValuesByName)) continue;
            added = true;
        }
        return added;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        for (Object o : c) {
            changed |= this.remove(o);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c == null) {
            return false;
        }
        Set valueSet = c.stream().filter(item -> item instanceof WithValues).map(item -> ((WithValues)item).getValues()).collect(Collectors.toSet());
        int size = this.size();
        int removed = 0;
        for (int i = size - 1; i >= 0; --i) {
            if (valueSet.contains(this.rows.get(i))) continue;
            this.rows.remove(i);
            ++removed;
        }
        return removed != 0;
    }

    @Override
    public void clear() {
        this.rows.clear();
    }
}

