/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.throwables;

import io.github.cruisoring.OfThrowable;
import io.github.cruisoring.throwables.SupplierThrowable;
import java.util.function.Function;

@FunctionalInterface
public interface FunctionThrowable<T, R>
extends OfThrowable<R> {
    public R apply(T var1) throws Exception;

    default public R tryApply(T t) {
        try {
            return this.apply(t);
        }
        catch (Exception e) {
            return this.handle(e);
        }
    }

    default public SupplierThrowable<R> asSupplierThrowable(T t) {
        return () -> this.apply(t);
    }

    default public Function<T, R> withHandler(Function<Exception, Object> ... exceptionHandlers) {
        if (exceptionHandlers == null || exceptionHandlers.length == 0) {
            return this::tryApply;
        }
        Function<Object, Object> function = t -> {
            try {
                return this.apply(t);
            }
            catch (Exception e) {
                return exceptionHandlers[0].apply(e);
            }
        };
        return function;
    }

    default public Function<T, R> orElse(R defaultValue) {
        Function<Object, Object> function = t -> {
            try {
                return this.apply(t);
            }
            catch (Exception e) {
                return defaultValue;
            }
        };
        return function;
    }
}

