/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.tuple;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.TypeHelper;
import io.github.cruisoring.logger.Logger;
import io.github.cruisoring.tuple.ITuple;
import io.github.cruisoring.tuple.Tuple0;
import io.github.cruisoring.tuple.Tuple1;
import io.github.cruisoring.tuple.Tuple10;
import io.github.cruisoring.tuple.Tuple2;
import io.github.cruisoring.tuple.Tuple3;
import io.github.cruisoring.tuple.Tuple4;
import io.github.cruisoring.tuple.Tuple5;
import io.github.cruisoring.tuple.Tuple6;
import io.github.cruisoring.tuple.Tuple7;
import io.github.cruisoring.tuple.Tuple8;
import io.github.cruisoring.tuple.Tuple9;
import io.github.cruisoring.tuple.TuplePlus;
import io.github.cruisoring.tuple.WithValues;
import io.github.cruisoring.utility.ArrayHelper;
import io.github.cruisoring.utility.SimpleTypedList;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;

public class Tuple<T>
implements ITuple<T> {
    public static final Tuple0 UNIT = new Tuple0();
    public static final Tuple1 TRUE = new Tuple1<Boolean>(true);
    public static final Tuple1 FALSE = new Tuple1<Boolean>(false);
    protected final T[] values;
    protected int[][] deepIndexes;
    protected Integer _hashCode;
    protected Set<Integer> _signatures;
    private boolean closed = false;

    public static <V> Tuple<V> setOf(V ... elements) {
        return new Tuple<V>(elements);
    }

    public static <V> Tuple<V> setOfType(Class<? extends V> elementType, V ... elements) {
        Asserts.assertAllNotNull(elements, elementType);
        return new Tuple<V>(elementType, elements);
    }

    public static <T> Tuple<T> setOfType(Class<? extends T> elementType, Collection<T> collection) {
        Asserts.assertAllNotNull(collection, elementType);
        Object[] array = collection.toArray((Object[])Array.newInstance(elementType, 0));
        return Tuple.setOfType(elementType, array);
    }

    public static Tuple of(Object ... elements) {
        if (elements == null) {
            return Tuple.create(null);
        }
        int length = elements.length;
        switch (length) {
            case 0: {
                return UNIT;
            }
            case 1: {
                return new Tuple1<Object>(elements[0]);
            }
            case 2: {
                return new Tuple2<Object, Object>(elements[0], elements[1]);
            }
            case 3: {
                return new Tuple3<Object, Object, Object>(elements[0], elements[1], elements[2]);
            }
            case 4: {
                return new Tuple4<Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3]);
            }
            case 5: {
                return new Tuple5<Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4]);
            }
            case 6: {
                return new Tuple6<Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5]);
            }
            case 7: {
                return new Tuple7<Object, Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6]);
            }
            case 8: {
                return new Tuple8<Object, Object, Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7]);
            }
            case 9: {
                return new Tuple9<Object, Object, Object, Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7], elements[8]);
            }
            case 10: {
                return new Tuple10<Object, Object, Object, Object, Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7], elements[8], elements[9]);
            }
        }
        return new TuplePlus<Object, Object, Object, Object, Object, Object, Object, Object, Object, Object>(elements[0], elements[1], elements[2], elements[3], elements[4], elements[5], elements[6], elements[7], elements[8], elements[9], Arrays.copyOfRange(elements, 10, length));
    }

    protected static Tuple0 create() {
        return UNIT;
    }

    public static <T> Tuple1<T> create(T t) {
        return new Tuple1<T>(t);
    }

    public static <T, U> Tuple2<T, U> create(T t, U u) {
        return new Tuple2<T, U>(t, u);
    }

    public static <T, U, V> Tuple3<T, U, V> create(T t, U u, V v) {
        return new Tuple3<T, U, V>(t, u, v);
    }

    public static <T, U, V, W> Tuple4<T, U, V, W> create(T t, U u, V v, W w) {
        return new Tuple4<T, U, V, W>(t, u, v, w);
    }

    public static <T, U, V, W, X> Tuple5<T, U, V, W, X> create(T t, U u, V v, W w, X x) {
        return new Tuple5<T, U, V, W, X>(t, u, v, w, x);
    }

    public static <T, U, V, W, X, Y> Tuple6<T, U, V, W, X, Y> create(T t, U u, V v, W w, X x, Y y) {
        return new Tuple6<T, U, V, W, X, Y>(t, u, v, w, x, y);
    }

    public static <T, U, V, W, X, Y, Z> Tuple7<T, U, V, W, X, Y, Z> create(T t, U u, V v, W w, X x, Y y, Z z) {
        return new Tuple7<T, U, V, W, X, Y, Z>(t, u, v, w, x, y, z);
    }

    public static <T, U, V, W, X, Y, Z, A> Tuple8<T, U, V, W, X, Y, Z, A> create(T t, U u, V v, W w, X x, Y y, Z z, A a) {
        return new Tuple8<T, U, V, W, X, Y, Z, A>(t, u, v, w, x, y, z, a);
    }

    public static <T, U, V, W, X, Y, Z, A, B> Tuple9<T, U, V, W, X, Y, Z, A, B> create(T t, U u, V v, W w, X x, Y y, Z z, A a, B b) {
        return new Tuple9<T, U, V, W, X, Y, Z, A, B>(t, u, v, w, x, y, z, a, b);
    }

    public static <T, U, V, W, X, Y, Z, A, B, C> Tuple10<T, U, V, W, X, Y, Z, A, B, C> create(T t, U u, V v, W w, X x, Y y, Z z, A a, B b, C c) {
        return new Tuple10<T, U, V, W, X, Y, Z, A, B, C>(t, u, v, w, x, y, z, a, b, c);
    }

    public static <T, U, V, W, X, Y, Z, A, B, C> TuplePlus<T, U, V, W, X, Y, Z, A, B, C> create(T t, U u, V v, W w, X x, Y y, Z z, A a, B b, C c, Object ... others) {
        return new TuplePlus<T, U, V, W, X, Y, Z, A, B, C>(t, u, v, w, x, y, z, a, b, c, others);
    }

    protected Tuple(Class<? extends T> eType, T ... elements) {
        this.values = elements == null ? (Object[])ArrayHelper.create(Asserts.checkNotNull(eType, "The element type must be specified."), 1, i -> null) : elements;
    }

    protected Tuple(Class<? extends T> eType, Collection elements) {
        Asserts.assertAllNotNull(eType, elements);
        Iterator iterator = elements.iterator();
        this.values = (Object[])ArrayHelper.create(eType, elements.size(), i -> iterator.next());
    }

    protected Tuple(T ... elements) {
        this.values = elements == null ? (Object[])ArrayHelper.create(Object.class, 1, i -> null) : elements;
    }

    public Class getElementType() {
        return this.values.getClass().getComponentType();
    }

    public T[] asArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    @Override
    public T getValue(int index) {
        if (index < 0 || index >= this.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[index];
    }

    @Override
    public <U> Tuple<U> getSetOf(Class<U> clazz) {
        Asserts.assertNotNull(clazz, "The clazz must be specified to get corresponding Set");
        try {
            Predicate<Class> predicate = TypeHelper.getClassEqualitor(clazz);
            Class equivalent = TypeHelper.isPrimitive(clazz) != false && !clazz.isArray() ? TypeHelper.getEquivalentClass(clazz) : clazz;
            int length = this.getLength();
            SimpleTypedList<Object> list = new SimpleTypedList<Object>(new Object[0]);
            for (int i = 0; i < length; ++i) {
                T v = this.values[i];
                if (v != null) {
                    Class<?> vClass = v.getClass();
                    if (equivalent.equals(vClass)) {
                        list.add(v);
                        continue;
                    }
                    if (!predicate.test(vClass)) continue;
                    Object t = TypeHelper.getToEquivalentParallelConverter(vClass).apply(v);
                    list.add(t);
                    continue;
                }
                if (TypeHelper.isPrimitive(clazz).booleanValue()) continue;
                list.add(null);
            }
            T[] array = list.toArray((T[])null);
            return Tuple.setOfType(equivalent, array);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public <S> Tuple<S> getSetOf(Class<S> clazz, Predicate<S> valuePredicate) {
        Asserts.assertAllNotNull(clazz, valuePredicate);
        SimpleTypedList<Object> matched = new SimpleTypedList<Object>(new Object[0]);
        Predicate<Class> classPredicate = TypeHelper.getClassEqualitor(clazz);
        int length = this.getLength();
        for (int i = 0; i < length; ++i) {
            T v = this.values[i];
            if (v == null) continue;
            try {
                if (!classPredicate.test(v.getClass()) || !valuePredicate.test(v)) continue;
                matched.add(v);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object[] array = matched.stream().toArray();
        return Tuple.setOfType(clazz, array);
    }

    @Override
    public int getLength() {
        return this.values.length;
    }

    @Override
    public int[][] getDeepIndexes() {
        if (this.deepIndexes == null) {
            this.deepIndexes = TypeHelper.getDeepIndexes(this.values);
        }
        return this.deepIndexes;
    }

    public int hashCode() {
        if (this._hashCode == null) {
            this._hashCode = TypeHelper.deepHashCode(this.values);
        }
        return this._hashCode;
    }

    @Override
    public Set<Integer> getSignatures() {
        if (this._signatures == null) {
            HashSet<Integer> hashCodes = new HashSet<Integer>();
            hashCodes.add(this.hashCode());
            Arrays.stream(this.values).forEach(v -> hashCodes.add(v == null ? 0 : v.hashCode()));
            this._signatures = Collections.unmodifiableSet(hashCodes);
        }
        return this._signatures;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Tuple)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Tuple other = (Tuple)obj;
        if (!other.canEqual(this) || other.getLength() != this.values.length || this.hashCode() != other.hashCode()) {
            return false;
        }
        return TypeHelper.valueEquals(this.values, other.values, this.getDeepIndexes(), other.getDeepIndexes());
    }

    @Override
    public boolean canEqual(Object obj) {
        Class otherElementTpe;
        if (!(obj instanceof Tuple)) {
            return false;
        }
        Tuple other = (Tuple)obj;
        Class thisElementType = this.getElementType();
        return thisElementType.isAssignableFrom(otherElementTpe = other.getElementType()) || otherElementTpe.isAssignableFrom(thisElementType);
    }

    @Override
    public int compareTo(Object o) {
        int otherLength;
        if (o == null) {
            return this.hashCode();
        }
        if (!(o instanceof WithValues)) {
            return this.hashCode() - o.hashCode();
        }
        WithValues other = (WithValues)o;
        int thisLength = this.getLength();
        int len = thisLength < (otherLength = other.getLength()) ? thisLength : otherLength;
        for (int i = 0; i < len; ++i) {
            int hash2;
            T t1 = this.getValue(i);
            int hash1 = t1 == null ? 0 : t1.hashCode();
            Object t2 = other.getValue(i);
            int n = hash2 = t2 == null ? 0 : t2.hashCode();
            if (hash1 == hash2) continue;
            return hash1 - hash2;
        }
        return thisLength - otherLength;
    }

    public String toString() {
        return TypeHelper.deepToString(this.values);
    }

    @Override
    public void close() throws Exception {
        if (!this.closed) {
            for (int i = this.values.length - 1; i >= 0; --i) {
                T value = this.values[i];
                if (!(value instanceof AutoCloseable)) continue;
                ((AutoCloseable)value).close();
                Logger.V("%s closed()", value);
            }
            this.closed = true;
            Logger.V("%s.close() run successfully!", this);
        }
    }
}

