/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.tuple;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.TypeHelper;
import io.github.cruisoring.throwables.PredicateThrowable;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public interface WithValues<T>
extends Comparable {
    public T getValue(int var1);

    public int getLength();

    public boolean canEqual(Object var1);

    public Set<Integer> getSignatures();

    default public WithValues getValues() {
        return this;
    }

    default public boolean isMatched(Map<Integer, Object> expectedValues) {
        for (Map.Entry<Integer, Object> entry : expectedValues.entrySet()) {
            if (TypeHelper.valueEquals(entry.getValue(), this.getValue(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    default public boolean meetConditions(Map<Integer, PredicateThrowable> expectedConditions) {
        for (Map.Entry<Integer, PredicateThrowable> entry : expectedConditions.entrySet()) {
            if (entry.getValue().withHandler(new Function[0]).test(this.getValue(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    default public boolean anyMatch(PredicateThrowable<T> predicateThrowable) {
        Asserts.assertAllNotNull(predicateThrowable, new PredicateThrowable[0]);
        int len = this.getLength();
        try {
            for (int i = 0; i < len; ++i) {
                if (!predicateThrowable.test(this.getValue(i))) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    default public boolean allMatch(PredicateThrowable<T> predicateThrowable) {
        Asserts.assertAllNotNull(predicateThrowable, new PredicateThrowable[0]);
        int len = this.getLength();
        try {
            for (int i = 0; i < len; ++i) {
                if (predicateThrowable.test(this.getValue(i))) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    default public boolean noneMatch(PredicateThrowable<T> predicateThrowable) {
        Asserts.assertAllNotNull(predicateThrowable, new PredicateThrowable[0]);
        int len = this.getLength();
        try {
            for (int i = 0; i < len; ++i) {
                if (!predicateThrowable.test(this.getValue(i))) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    default public int compareTo(Object o) {
        return o == null ? this.hashCode() : this.hashCode() - o.hashCode();
    }
}

