/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.utility;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.Range;
import io.github.cruisoring.TypeHelper;
import io.github.cruisoring.TypedList;
import io.github.cruisoring.repository.TupleRepository3;
import io.github.cruisoring.throwables.BiConsumerThrowable;
import io.github.cruisoring.throwables.FunctionThrowable;
import io.github.cruisoring.throwables.TriConsumerThrowable;
import io.github.cruisoring.throwables.TriFunctionThrowable;
import io.github.cruisoring.tuple.Tuple;
import io.github.cruisoring.tuple.Tuple3;
import io.github.cruisoring.utility.ReadOnlyList;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class ArrayHelper {
    public static final Class ObjectClass = Object.class;
    private static final TupleRepository3<Class, BiConsumerThrowable<Object, FunctionThrowable<Integer, Object>>, BiConsumerThrowable<Object, FunctionThrowable<Integer, Object>>, BiConsumerThrowable<Object, FunctionThrowable<Integer, Object>>> arraySetters = TupleRepository3.fromKey(ArrayHelper::getAssetSetter);
    public static int ParalellEvaluationThreashold = 100;

    private ArrayHelper() {
    }

    public static <T> TypedList<T> asList(T ... elements) {
        ReadOnlyList<T> list = new ReadOnlyList<T>(elements);
        return list;
    }

    public static Object getNewArray(Class clazz, int length) {
        if (clazz == Object.class) {
            return new Object[length];
        }
        FunctionThrowable<Integer, Object> factory = TypeHelper.getArrayFactory(clazz);
        return factory.orElse(null).apply(length);
    }

    public static <T> T[] getNewArray(Class<? extends T> clazz, int length, T defaultValue) {
        Object[] array = clazz == Object.class ? new Object[length] : TypeHelper.getArrayFactory(clazz).orElse(null).apply(length);
        for (int i = 0; i < length; ++i) {
            array[i] = defaultValue;
        }
        return array;
    }

    public static <T> Object create(Class<? extends T> clazz, int length, Function<Integer, T> elementSupplier) {
        Asserts.assertAllNotNull(elementSupplier, new Function[0]);
        Object[] array = clazz == Object.class ? new Object[length] : TypeHelper.getArrayFactory(clazz).orElse(null).apply(length);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, elementSupplier.apply(i));
        }
        return array;
    }

    public static Class getComponentType(Object array) {
        if (array == null) {
            return null;
        }
        Class<?> arrayClass = array.getClass();
        if (!arrayClass.isArray()) {
            return null;
        }
        return arrayClass.getComponentType();
    }

    public static <T> T[] merge(T[] array, T ... others) {
        Asserts.assertFalse(array == null && others == null, "No way to get the element type with two nulls");
        if (array == null) {
            return (Object[])ArrayHelper.create(others.getClass().getComponentType(), others.length + 1, i -> i == 0 ? null : others[i - 1]);
        }
        if (others == null) {
            return (Object[])ArrayHelper.create(array.getClass().getComponentType(), array.length + 1, i -> i < array.length ? array[i] : null);
        }
        int arrayLength = array.length;
        return (Object[])ArrayHelper.create(array.getClass().getComponentType(), arrayLength + others.length, i -> i < arrayLength ? array[i] : others[i - arrayLength]);
    }

    public static <T> Object[] mergeVarargsFirst(T[] extras, T ... array) {
        if (extras == null && array == null) {
            return (Object[])ArrayHelper.create(Object.class, 2, i -> null);
        }
        if (extras == null) {
            Class<?> elementType = array.getClass().getComponentType();
            extras = (Object[])ArrayHelper.create(elementType, 1, i -> null);
        } else if (array == null) {
            Class<?> elementType = extras.getClass().getComponentType();
            array = (Object[])ArrayHelper.create(elementType, 1, i -> null);
        }
        return ArrayHelper.merge(array, extras);
    }

    public static Object arrayOf(Object first, Object ... others) {
        Object firstElement;
        Asserts.assertAllTrue(others != null, new boolean[0]);
        Class<?> class1 = first.getClass();
        boolean isArray1 = class1.isArray();
        Class<?> componentClass1 = isArray1 ? class1.getComponentType() : class1;
        boolean isPremitive1 = TypeHelper.isPrimitive(class1);
        int length1 = class1.isArray() ? Array.getLength(first) : 1;
        int length2 = Array.getLength(others);
        Object firstArrayElement = null;
        if (length2 == 0) {
            if (isArray1) {
                Class<?> componentClass = class1.getComponentType();
                TriFunctionThrowable<Object, Integer, Integer, Object> copier = TypeHelper.getArrayRangeCopier(componentClass);
                return copier.orElse(null).apply(first, 0, length1);
            }
            try {
                Object resultArray = TypeHelper.getArrayFactory(class1).apply(1);
                TriConsumerThrowable<Object, Integer, Object> elementSetter = TypeHelper.getArrayElementSetter(class1);
                elementSetter.accept(resultArray, 0, first);
                return resultArray;
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (length2 == 1 && (firstElement = Array.get(others, 0)) != null) {
            Class<?> firstElementClass = firstElement.getClass();
            firstArrayElement = firstElementClass.isArray() ? firstElement : ArrayHelper.arrayOf(firstElement, new Object[0]);
        }
        Object[] array2 = firstArrayElement == null ? others : firstArrayElement;
        Class<?> class2 = array2.getClass();
        length2 = Array.getLength(array2);
        boolean isPremitive2 = TypeHelper.isPrimitive(class2);
        Class<?> componentClass2 = class2.getComponentType();
        FunctionThrowable<Integer, Object> elementGetter = i -> i < length1 ? (isArray1 ? Array.get(first, i) : first) : Array.get(array2, i - length1);
        Class<Object> resultComponentClass = componentClass1.equals(componentClass2) || TypeHelper.areEquivalent(componentClass1, componentClass2) ? (isPremitive1 && !isPremitive2 ? componentClass2 : componentClass1) : (!isPremitive1 && componentClass1.isAssignableFrom(componentClass2) || isPremitive2 && componentClass1.isAssignableFrom(TypeHelper.getEquivalentClass(componentClass2)) ? componentClass1 : (!isPremitive2 && componentClass2.isAssignableFrom(componentClass1) || isPremitive1 && componentClass2.isAssignableFrom(TypeHelper.getEquivalentClass(componentClass1)) ? componentClass2 : Object.class));
        Object resultArray = TypeHelper.getArrayFactory(resultComponentClass).orElse(null).apply(length1 + length2);
        try {
            ArrayHelper.setAll(resultArray, elementGetter);
            return resultArray;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static Map<Class, Tuple3<BiConsumerThrowable<Object, FunctionThrowable<Integer, Object>>, BiConsumerThrowable<Object, FunctionThrowable<Integer, Object>>, BiConsumerThrowable<Object, FunctionThrowable<Integer, Object>>>> getArraysSetAll() {
        BiConsumerThrowable<Object, FunctionThrowable> serialSetAll;
        HashMap<Class, Tuple3<BiConsumerThrowable<Object, FunctionThrowable<Integer, Object>>, BiConsumerThrowable<Object, FunctionThrowable<Integer, Object>>, BiConsumerThrowable<Object, FunctionThrowable<Integer, Object>>>> map = new HashMap<Class, Tuple3<BiConsumerThrowable<Object, FunctionThrowable<Integer, Object>>, BiConsumerThrowable<Object, FunctionThrowable<Integer, Object>>, BiConsumerThrowable<Object, FunctionThrowable<Integer, Object>>>>();
        BiConsumerThrowable<Object, FunctionThrowable> parallelSetAll = (array, intFunction) -> Arrays.parallelSetAll((int[])array, i -> intFunction.orElse(0).apply(i));
        BiConsumerThrowable<Object, FunctionThrowable> setAll = serialSetAll = (array, intFunction) -> Arrays.setAll((int[])array, (int i) -> intFunction.orElse(0).apply(i));
        map.put(Integer.TYPE, Tuple.create(parallelSetAll, serialSetAll, setAll));
        parallelSetAll = (array, intFunction) -> Arrays.parallelSetAll((double[])array, i -> intFunction.orElse(0.0).apply(i));
        setAll = serialSetAll = (array, intFunction) -> Arrays.setAll((double[])array, (int i) -> (Double)((Object)intFunction.orElse(0).apply(i)));
        map.put(Double.TYPE, Tuple.create(parallelSetAll, serialSetAll, setAll));
        parallelSetAll = (array, intFunction) -> Arrays.parallelSetAll((long[])array, i -> intFunction.orElse(0L).apply(i));
        setAll = serialSetAll = (array, intFunction) -> Arrays.setAll((long[])array, (int i) -> intFunction.orElse(0L).apply(i));
        map.put(Long.TYPE, Tuple.create(parallelSetAll, serialSetAll, setAll));
        return map;
    }

    private static Tuple3<BiConsumerThrowable<Object, FunctionThrowable<Integer, Object>>, BiConsumerThrowable<Object, FunctionThrowable<Integer, Object>>, BiConsumerThrowable<Object, FunctionThrowable<Integer, Object>>> getAssetSetter(Class componentClass) {
        Asserts.assertAllNotNull(componentClass, new Class[0]);
        TriConsumerThrowable<Object, Integer, Object> elementSetter = TypeHelper.getArrayElementSetter(componentClass);
        TriFunctionThrowable.TriFunction<Object, Integer, Object, Boolean> setElementWithException = (array, index, element) -> {
            try {
                elementSetter.accept(array, (Integer)index, element);
                return false;
            }
            catch (Exception ex) {
                return true;
            }
        };
        BiConsumerThrowable<Object, FunctionThrowable> parallelSetAll = (array, generator) -> {
            int length = Array.getLength(array);
            Integer indexWithException = ((Stream)IntStream.range(0, length).boxed().parallel()).filter(i -> (Boolean)setElementWithException.apply(array, (Integer)i, generator.orElse(null).apply((Integer)i))).findFirst().orElse(-1);
        };
        BiConsumerThrowable<Object, FunctionThrowable> serialSetAll = (array, generator) -> {
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                Object element = generator.apply(i);
                elementSetter.accept(array, i, element);
            }
        };
        BiConsumerThrowable<Object, FunctionThrowable> defaultSetAll = (array, generator) -> {
            int length = Array.getLength(array);
            if (length < TypeHelper.PARALLEL_EVALUATION_THRESHOLD) {
                for (int i2 = 0; i2 < length; ++i2) {
                    Object element = generator.apply(i2);
                    elementSetter.accept(array, i2, element);
                }
            } else {
                Integer n = ((Stream)IntStream.range(0, length).boxed().parallel()).filter(i -> (Boolean)setElementWithException.apply(array, (Integer)i, generator.orElse(null).apply((Integer)i))).findFirst().orElse(-1);
            }
        };
        return Tuple.create(parallelSetAll, serialSetAll, defaultSetAll);
    }

    public static void setAllParallel(Object array, FunctionThrowable<Integer, Object> generator) {
        try {
            ((BiConsumerThrowable)arraySetters.getFirstValue(ArrayHelper.getComponentType(array))).accept(array, generator);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setAllSerial(Object array, FunctionThrowable<Integer, Object> generator) {
        try {
            ((BiConsumerThrowable)arraySetters.getSecondValue(ArrayHelper.getComponentType(array))).accept(array, generator);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setAll(Object array, FunctionThrowable<Integer, Object> generator) {
        try {
            ((BiConsumerThrowable)arraySetters.getThirdValue(ArrayHelper.getComponentType(array))).accept(array, generator);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T> Object[] toObjectArray(T[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])TypeHelper.convert(array, Object.class);
    }

    public static Boolean[] toObject(boolean[] values) {
        return (Boolean[])TypeHelper.toEquivalent(values);
    }

    public static Byte[] toObject(byte[] values) {
        if (values == null) {
            return null;
        }
        return (Byte[])TypeHelper.toEquivalent(values);
    }

    public static Character[] toObject(char[] values) {
        if (values == null) {
            return null;
        }
        return (Character[])TypeHelper.toEquivalent(values);
    }

    public static Float[] toObject(float[] values) {
        if (values == null) {
            return null;
        }
        return (Float[])TypeHelper.toEquivalent(values);
    }

    public static Double[] toObject(double[] values) {
        if (values == null) {
            return null;
        }
        return (Double[])TypeHelper.toEquivalent(values);
    }

    public static Integer[] toObject(int[] values) {
        if (values == null) {
            return null;
        }
        return (Integer[])TypeHelper.toEquivalent(values);
    }

    public static Short[] toObject(short[] values) {
        if (values == null) {
            return null;
        }
        return (Short[])TypeHelper.toEquivalent(values);
    }

    public static Long[] toObject(long[] values) {
        if (values == null) {
            return null;
        }
        return (Long[])TypeHelper.toEquivalent(values);
    }

    public static boolean[] toPrimitive(Boolean[] values) {
        if (values == null) {
            return null;
        }
        if (values.length > 0) {
            Asserts.assertAllNotNull(values[0], (Boolean[])TypeHelper.copyOfRange(values, 1, values.length));
        }
        return (boolean[])TypeHelper.toEquivalent(values);
    }

    public static byte[] toPrimitive(Byte[] values) {
        if (values == null) {
            return null;
        }
        if (values.length > 0) {
            Asserts.assertAllNotNull(values[0], (Byte[])TypeHelper.copyOfRange(values, 1, values.length));
        }
        return (byte[])TypeHelper.toEquivalent(values);
    }

    public static char[] toPrimitive(Character[] values) {
        if (values == null) {
            return null;
        }
        if (values.length > 0) {
            Asserts.assertAllNotNull(values[0], (Character[])TypeHelper.copyOfRange(values, 1, values.length));
        }
        return (char[])TypeHelper.toEquivalent(values);
    }

    public static float[] toPrimitive(Float[] values) {
        if (values == null) {
            return null;
        }
        if (values.length > 0) {
            Asserts.assertAllNotNull(values[0], (Float[])TypeHelper.copyOfRange(values, 1, values.length));
        }
        return (float[])TypeHelper.toEquivalent(values);
    }

    public static double[] toPrimitive(Double[] values) {
        if (values == null) {
            return null;
        }
        if (values.length > 0) {
            Asserts.assertAllNotNull(values[0], (Double[])TypeHelper.copyOfRange(values, 1, values.length));
        }
        return (double[])TypeHelper.toEquivalent(values);
    }

    public static int[] toPrimitive(Integer[] values) {
        if (values == null) {
            return null;
        }
        if (values.length > 0) {
            Asserts.assertAllNotNull(values[0], (Integer[])TypeHelper.copyOfRange(values, 1, values.length));
        }
        return (int[])TypeHelper.toEquivalent(values);
    }

    public static short[] toPrimitive(Short[] values) {
        if (values == null) {
            return null;
        }
        if (values.length > 0) {
            Asserts.assertAllNotNull(values[0], (Short[])TypeHelper.copyOfRange(values, 1, values.length));
        }
        return (short[])TypeHelper.toEquivalent(values);
    }

    public static long[] toPrimitive(Long[] values) {
        if (values == null) {
            return null;
        }
        if (values.length > 0) {
            Asserts.assertAllNotNull(values[0], (Long[])TypeHelper.copyOfRange(values, 1, values.length));
        }
        return (long[])TypeHelper.toEquivalent(values);
    }

    public static Object shuffle(Object original) {
        Class<?> arrayClass = Asserts.checkNotNull(original, "The given array is null").getClass();
        Asserts.assertTrue(arrayClass.isArray(), "The given value must be an array!");
        int len = Array.getLength(original);
        if (len < 2) {
            return TypeHelper.copyOfRange(original, 0, len);
        }
        Integer[] indexes = Range.closedOpen(0, len).getRandomIndexes();
        Object shuffled = ArrayHelper.create(original.getClass().getComponentType(), len, i -> Array.get(original, indexes[i]));
        return shuffled;
    }

    public static <T> TypedList<T> asList(T[] elements, int from, int to) {
        ReadOnlyList<T> list = new ReadOnlyList<T>(elements, from, to);
        return list;
    }
}

