/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.utility;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.Range;
import io.github.cruisoring.TypeHelper;
import io.github.cruisoring.logger.Logger;
import io.github.cruisoring.repository.Repository;
import io.github.cruisoring.throwables.FunctionThrowable;
import io.github.cruisoring.throwables.TriConsumerThrowable;
import io.github.cruisoring.utility.ArrayHelper;
import java.lang.reflect.MalformedParametersException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class StringHelper {
    public static final String PercentageAscii = "&#37";
    public static final Function<Object, String[]> defaultToStringForms = StringHelper::commonToStrings;
    public static final BiPredicate<String, String> contains = StringUtils::contains;
    public static final BiPredicate<String, String> containsIgnoreCase = StringUtils::containsIgnoreCase;
    private static final Repository<Class, FunctionThrowable<String, Object>> stringParsers = new Repository<Class, FunctionThrowable>(new HashMap<Class, FunctionThrowable<String, Object>>(){
        {
            this.put(Integer.class, Integer::decode);
            this.put(Integer.TYPE, s -> (int)Integer.decode(s));
            this.put(Double.class, Double::valueOf);
            this.put(Double.TYPE, s -> (double)Double.valueOf(s));
            this.put(Short.class, Short::valueOf);
            this.put(Short.TYPE, s -> (short)Short.valueOf(s));
            this.put(Long.class, Long::valueOf);
            this.put(Long.TYPE, s -> (long)Long.valueOf(s));
            this.put(Boolean.class, Boolean::valueOf);
            this.put(Boolean.TYPE, s -> (boolean)Boolean.valueOf(s));
            this.put(Float.class, Float::valueOf);
            this.put(Float.TYPE, s -> Float.valueOf(Float.valueOf(s).floatValue()));
            this.put(Byte.class, Byte::valueOf);
            this.put(Byte.TYPE, s -> (byte)Byte.valueOf(s));
            this.put(Character.class, s -> Character.valueOf(s.charAt(0)));
            this.put(Character.TYPE, s -> Character.valueOf(s.charAt(0)));
        }
    }, null, StringHelper::getParser);

    private StringHelper() {
    }

    private static final String[] commonToStrings(Object obj) {
        if (obj == null) {
            return new String[]{"null", "NULL"};
        }
        Class<?> objClass = obj.getClass();
        if (objClass.isArray()) {
            return new String[]{TypeHelper.deepToString(obj)};
        }
        return new String[]{obj.toString()};
    }

    public static <E extends Enum<E>> E parseEnum(Class<E> enumClass, String enumString) throws Exception {
        Enum[] enumValues = (Enum[])enumClass.getEnumConstants();
        Enum matchedOrFirst = Arrays.stream(enumValues).filter(e -> e.toString().equalsIgnoreCase(enumString)).findFirst().orElse(enumValues[0]);
        return (E)matchedOrFirst;
    }

    private static Object throwsException(String s) throws Exception {
        throw new Exception();
    }

    private static FunctionThrowable<String, Object> getParser(Class clazz) throws Exception {
        Asserts.assertAllNotNull(clazz, new Class[0]);
        if (stringParsers.containsKey(clazz)) {
            return stringParsers.get(clazz, null);
        }
        if (TypeHelper.isPrimitive(clazz).booleanValue()) {
            return StringHelper.getParser(TypeHelper.getEquivalentClass(clazz));
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return s -> StringHelper.parseEnum(clazz, s);
        }
        if (clazz.isArray()) {
            Class<?> componentClass = clazz.getComponentType();
            FunctionThrowable<String, Object> componentParser = StringHelper.getParser(componentClass);
            TriConsumerThrowable<Object, Integer, Object> equivalentSetter = TypeHelper.getArrayElementSetter(componentClass);
            if (componentParser == null || equivalentSetter == null) {
                return StringHelper::throwsException;
            }
            return s -> {
                if (!(s = s.trim()).startsWith("[") || !s.endsWith("]")) {
                    throw new MalformedParametersException("Array types shall be wrapped within '[]' and seperated by ','s.");
                }
                String[] substrings = s.substring(1, s.length() - 1).split(",");
                int length = substrings.length;
                Object parsedValues = ArrayHelper.getNewArray(componentClass, length);
                for (int i = 0; i < length; ++i) {
                    equivalentSetter.accept(parsedValues, i, componentParser.apply(substrings[i]));
                }
                return parsedValues;
            };
        }
        throw new Exception("Not support!");
    }

    public static <T> T parse(String objString, Class<T> objectType, T defaultValue) {
        if (objString == null || objectType == null) {
            return defaultValue;
        }
        try {
            FunctionThrowable<String, Object> parser = stringParsers.apply(objectType);
            return (T)parser.apply(objString);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static boolean containsAll(Collection<String> collection, Collection<String> targets) {
        Asserts.assertAllNotNull(collection, targets);
        for (String target : targets) {
            if (collection.contains(target)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAllIgnoreCase(Collection<String> collection, Collection<String> targets) {
        Asserts.assertAllNotNull(collection, targets);
        List lowerCases = collection.stream().map(s -> s == null ? null : s.toLowerCase()).collect(Collectors.toList());
        for (String target : targets) {
            if (lowerCases.contains(target == null ? null : target.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Function<Object, String[]> toStringForms, String context, Object ... keys) {
        Asserts.assertAllNotNull(context, toStringForms);
        if (keys == null) {
            return context.contains("null");
        }
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            String[] options = toStringForms.apply(key);
            boolean containsKey = false;
            for (String option : options) {
                if (!context.contains(option)) continue;
                containsKey = true;
                break;
            }
            if (containsKey) continue;
            Logger.V("%s doesn't contains %s.", Range.ofLength(100).intersectionWith(Range.ofLength(context.length())).subString(context), key);
            return false;
        }
        return true;
    }

    public static boolean containsAll(String context, Object ... keys) {
        return StringHelper.containsAll(defaultToStringForms, context, keys);
    }

    public static Boolean containsAllIgnoreCase(Function<Object, String[]> toStringForms, String context, Object ... keys) {
        Asserts.assertAllNotNull(context, toStringForms);
        if (keys == null) {
            return StringUtils.containsIgnoreCase((CharSequence)context, (CharSequence)"null");
        }
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            String[] options = toStringForms.apply(key);
            int optionlength = options.length;
            for (int j = 0; j < optionlength && !StringUtils.containsIgnoreCase((CharSequence)context, (CharSequence)options[j]); ++j) {
                if (j != optionlength - 1) continue;
                Logger.V("%s doesn't contain %s", context.length() < 100 ? context : context.substring(0, 100) + "...", key);
                return false;
            }
        }
        return true;
    }

    public static boolean containsAllIgnoreCase(String context, Object ... keys) {
        return StringHelper.containsAllIgnoreCase(defaultToStringForms, context, keys);
    }

    public static boolean containsAny(Function<Object, String[]> toStringForms, String context, Object ... keys) {
        Asserts.assertAllNotNull(context, toStringForms);
        if (keys == null) {
            return StringUtils.contains((CharSequence)context, (CharSequence)"null");
        }
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            String[] options = toStringForms.apply(key);
            int optionlength = options.length;
            for (int j = 0; j < optionlength; ++j) {
                if (!StringUtils.contains((CharSequence)context, (CharSequence)options[j])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(String context, Object ... keys) {
        return StringHelper.containsAny(defaultToStringForms, context, keys);
    }

    public static boolean containsAnyIgnoreCase(Function<Object, String[]> toStringForms, String context, Object ... keys) {
        Asserts.assertAllNotNull(context, toStringForms);
        if (keys == null) {
            return StringUtils.containsIgnoreCase((CharSequence)context, (CharSequence)"null");
        }
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            String[] options = toStringForms.apply(key);
            int optionlength = options.length;
            for (int j = 0; j < optionlength; ++j) {
                if (!StringUtils.containsIgnoreCase((CharSequence)context, (CharSequence)options[j])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAnyIgnoreCase(String context, Object ... keys) {
        return StringHelper.containsAnyIgnoreCase(defaultToStringForms, context, keys);
    }

    public static String tryFormatString(String format, Object ... args) {
        if (args.length == 1 && args[0] instanceof Object[]) {
            args = (Object[])args[0];
        }
        try {
            String formatted = String.format(format, args);
            formatted = formatted.replaceAll(PercentageAscii, "%");
            return formatted;
        }
        catch (Exception e) {
            CharSequence[] argStrings = (String[])Arrays.stream(args).map(arg -> arg == null ? "null" : arg.toString()).toArray(String[]::new);
            return String.format("MalFormated format: '%s' where args[%d]: '%s'", format, args.length, String.join((CharSequence)", ", argStrings));
        }
    }

    public static <T> T tryGetProperty(Properties properties, T defaultValue, String ... valueKeys) {
        if (properties == null || defaultValue == null || valueKeys == null) {
            return defaultValue;
        }
        for (String key : valueKeys) {
            String valueString = properties.getProperty(key);
            if (valueString == null) continue;
            StringHelper.parse(valueString, defaultValue.getClass(), defaultValue);
        }
        return defaultValue;
    }

    public static <T> T tryParseSystemProperties(T defaultValue, String ... valueKeys) {
        if (defaultValue == null || valueKeys == null) {
            return defaultValue;
        }
        for (String key : valueKeys) {
            String valueString = System.getProperty(key);
            if (valueString == null) continue;
            StringHelper.parse(valueString, defaultValue.getClass(), defaultValue);
        }
        return defaultValue;
    }

    public static <T> T tryParseSystemProperties(T defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        Class<?> valueClass = defaultValue.getClass();
        return StringHelper.tryParseSystemProperties(defaultValue, valueClass.getName(), valueClass.getSimpleName());
    }
}

