/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruisoring.utility;

import io.github.cruisoring.Asserts;
import io.github.cruisoring.utility.StringHelper;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class TypedListIterator<E>
implements ListIterator<E> {
    static final String LIST_CANNOT_BE_NULL = "The list instance must be specified.";
    final List<E> list;
    int fromInclusive;
    int toExclusive;
    int cursor;
    int lastReturned = -1;

    public TypedListIterator(List<E> list) {
        this(Asserts.checkNotNull(list, LIST_CANNOT_BE_NULL), 0);
    }

    public TypedListIterator(List<E> list, int position) {
        this(Asserts.checkNotNull(list, LIST_CANNOT_BE_NULL), position, 0, list.size());
    }

    public TypedListIterator(List<E> list, int position, int from, int to) {
        this.list = Asserts.checkNotNull(list, LIST_CANNOT_BE_NULL);
        Asserts.assertAllFalse(from < 0, to > list.size(), from > to, position < from, position > to);
        this.fromInclusive = from;
        this.toExclusive = to;
        this.cursor = position;
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.toExclusive;
    }

    @Override
    public E next() {
        if (this.cursor >= this.toExclusive) {
            throw new NoSuchElementException(StringHelper.tryFormatString("No next element when cursor(%d) >= toExclusive(%d)", this.cursor, this.toExclusive));
        }
        this.lastReturned = this.cursor++;
        return this.list.get(this.lastReturned);
    }

    @Override
    public int nextIndex() {
        return this.cursor;
    }

    @Override
    public boolean hasPrevious() {
        return this.cursor > this.fromInclusive;
    }

    @Override
    public E previous() {
        if (this.cursor <= this.fromInclusive) {
            throw new NoSuchElementException(StringHelper.tryFormatString("No previous element when cursor(%d) <= fromInclusive(%d)", this.cursor, this.fromInclusive));
        }
        this.lastReturned = --this.cursor;
        return this.list.get(this.lastReturned);
    }

    @Override
    public int previousIndex() {
        return this.cursor - 1;
    }

    @Override
    public void add(E e) {
        this.list.add(this.cursor++, e);
        this.lastReturned = -1;
        ++this.toExclusive;
    }

    @Override
    public void set(E e) {
        if (this.lastReturned < 0) {
            throw new IllegalStateException("No element returned yet.");
        }
        this.list.set(this.lastReturned, e);
    }

    @Override
    public void remove() {
        if (this.lastReturned < 0) {
            throw new IllegalStateException("No element returned yet.");
        }
        this.cursor = this.lastReturned;
        this.list.remove(this.cursor);
        this.lastReturned = -1;
        --this.toExclusive;
    }
}

