/*
 * Decompiled with CFR 0.152.
 */
package io.github.dailystruggle.commandsapi.bukkit.LocalParameters;

import io.github.dailystruggle.commandsapi.bukkit.BukkitParameter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;

public class FloatParameter
extends BukkitParameter {
    List<String> allValues;

    public FloatParameter(BiFunction<CommandSender, String, Boolean> isRelevant, Vector<Double> range) {
        super(isRelevant);
        this.allValues = new ArrayList<String>();
        int maxSteps = 20;
        double span = range.lastElement() - range.firstElement();
        double step = span / (double)maxSteps;
        DecimalFormat decimalFormat = new DecimalFormat("###.##");
        double i = range.firstElement();
        while (i < range.lastElement()) {
            this.allValues.add(String.valueOf(decimalFormat.format(i)));
            i = step > 1.0 ? i + 1.0 : i + step;
        }
    }

    public FloatParameter(BiFunction<CommandSender, String, Boolean> isRelevant, Object ... options) {
        super(isRelevant);
        DecimalFormat decimalFormat = new DecimalFormat("###.##");
        this.allValues = Arrays.stream(options).map(decimalFormat::format).collect(Collectors.toList());
    }

    @Override
    public Collection<String> values() {
        return this.allValues;
    }
}

