/*
 * Decompiled with CFR 0.152.
 */
package io.github.dailystruggle.commandsapi.bukkit.LocalParameters;

import io.github.dailystruggle.commandsapi.bukkit.BukkitParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;

public class IntegerParameter
extends BukkitParameter {
    List<String> allValues;

    public IntegerParameter(BiFunction<CommandSender, String, Boolean> isRelevant, Vector<Integer> range) {
        super(isRelevant);
        this.allValues = new ArrayList<String>();
        int maxSteps = 20;
        double span = range.lastElement() - range.firstElement();
        double step = span / (double)maxSteps;
        double i = range.firstElement().intValue();
        while (i < (double)range.lastElement().intValue()) {
            this.allValues.add(String.valueOf((int)i));
            i = step > 1.0 ? i + 1.0 : i + step;
        }
    }

    public IntegerParameter(BiFunction<CommandSender, String, Boolean> isRelevant, Object ... options) {
        super(isRelevant);
        this.allValues = Arrays.stream(options).map(String::valueOf).collect(Collectors.toList());
    }

    @Override
    public Collection<String> values() {
        return this.allValues;
    }
}

