/*
 * Decompiled with CFR 0.152.
 */
package io.github.dailystruggle.commandsapi.bukkit.localCommands;

import io.github.dailystruggle.commandsapi.bukkit.BukkitCommand;
import io.github.dailystruggle.commandsapi.common.CommandParameter;
import io.github.dailystruggle.commandsapi.common.CommandsAPI;
import io.github.dailystruggle.commandsapi.common.CommandsAPICommand;
import io.github.dailystruggle.commandsapi.common.localCommands.TreeCommand;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class BukkitTreeCommand
extends BukkitCommand
implements TreeCommand {
    protected final Map<String, CommandParameter> parameterLookup = new ConcurrentHashMap<String, CommandParameter>();
    protected final Map<String, CommandsAPICommand> commandLookup = new ConcurrentHashMap<String, CommandsAPICommand>();

    public BukkitTreeCommand(Plugin plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        UUID senderId = sender instanceof Player ? ((Player)sender).getUniqueId() : CommandsAPI.serverId;
        Predicate<String> permissionCheckMethod = arg_0 -> ((CommandSender)sender).hasPermission(arg_0);
        Consumer<String> messageMethod = arg_0 -> ((CommandSender)sender).sendMessage(arg_0);
        return this.onCommand(senderId, permissionCheckMethod, messageMethod, args);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        UUID senderId = sender instanceof Player ? ((Player)sender).getUniqueId() : CommandsAPI.serverId;
        Predicate<String> permissionCheckMethod = arg_0 -> ((CommandSender)sender).hasPermission(arg_0);
        return this.onTabComplete(senderId, permissionCheckMethod, args);
    }

    @Override
    public boolean onCommand(UUID callerId, Map<String, String> parameterValues, CommandsAPICommand nextCommand) {
        ConsoleCommandSender commandSender;
        if (callerId.equals(CommandsAPI.serverId)) {
            commandSender = Bukkit.getConsoleSender();
        } else {
            commandSender = Bukkit.getPlayer((UUID)callerId);
            if (commandSender == null) {
                return false;
            }
        }
        return this.onCommand((CommandSender)commandSender, parameterValues, nextCommand);
    }

    public abstract boolean onCommand(CommandSender var1, Map<String, String> var2, CommandsAPICommand var3);

    @Override
    public Map<String, CommandParameter> getParameterLookup() {
        return this.parameterLookup;
    }

    @Override
    public Map<String, CommandsAPICommand> getCommandLookup() {
        return this.commandLookup;
    }
}

