/*
 * Decompiled with CFR 0.152.
 */
package io.github.dailystruggle.commandsapi.common.localCommands;

import io.github.dailystruggle.commandsapi.common.CommandParameter;
import io.github.dailystruggle.commandsapi.common.CommandsAPI;
import io.github.dailystruggle.commandsapi.common.CommandsAPICommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public interface TreeCommand
extends CommandsAPICommand {
    default public void addParameter(String name, CommandParameter parameter) {
        this.getParameterLookup().put(name.toLowerCase(), parameter);
    }

    default public void addSubCommand(String name, CommandsAPICommand command) {
        this.getCommandLookup().put(name.toUpperCase(), command);
    }

    public Map<String, CommandParameter> getParameterLookup();

    public Map<String, CommandsAPICommand> getCommandLookup();

    @Override
    default public List<String> onTabComplete(UUID callerId, Predicate<String> permissionCheckMethod, String[] args) {
        ArrayList<String> possibleResults;
        block6: {
            int i;
            block4: {
                String arg;
                block5: {
                    int delimiterIdx;
                    for (i = 0; i < args.length && args[i].contains(String.valueOf(CommandsAPI.parameterDelimiter)); ++i) {
                    }
                    possibleResults = new ArrayList<String>();
                    if (i != args.length) break block4;
                    String string = arg = (delimiterIdx = args[--i].indexOf(CommandsAPI.parameterDelimiter)) > 0 ? args[i].substring(0, delimiterIdx) : args[i];
                    if (delimiterIdx >= 0) break block5;
                    for (CommandsAPICommand command : this.getCommandLookup().values()) {
                        if (!permissionCheckMethod.test(command.permission())) continue;
                        possibleResults.add(command.name());
                    }
                    break block6;
                }
                if (!this.getCommandLookup().containsKey(arg)) break block6;
                ArrayList<String> relevantValues = new ArrayList<String>(this.getParameterLookup().get(arg).relevantValues(callerId));
                relevantValues.forEach(s -> {
                    s = arg + CommandsAPI.parameterDelimiter + (String)s;
                });
                possibleResults.addAll(relevantValues);
                break block6;
            }
            CommandsAPICommand nextCommand = this.getCommandLookup().get(args[i]);
            if (nextCommand != null) {
                return nextCommand.onTabComplete(callerId, permissionCheckMethod, Arrays.copyOfRange(args, 1, args.length));
            }
            for (Map.Entry<String, CommandsAPICommand> entry : this.getCommandLookup().entrySet()) {
                if (!permissionCheckMethod.test(entry.getValue().permission())) continue;
                possibleResults.add(entry.getKey());
            }
        }
        return possibleResults.stream().filter(s -> s.startsWith(args[args.length - 1])).collect(Collectors.toList());
    }

    @Override
    default public boolean onCommand(UUID callerId, Predicate<String> permissionCheckMethod, Consumer<String> messageMethod, String[] args) {
        if (!permissionCheckMethod.test(this.permission())) {
            return false;
        }
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.endsWith(String.valueOf(CommandsAPI.parameterDelimiter))) {
                messageMethod.accept("no value given for " + arg);
                continue;
            }
            String[] argSplit = arg.split(String.valueOf(CommandsAPI.parameterDelimiter));
            if (argSplit.length < 2) {
                CommandsAPICommand subCommand = this.getCommandLookup().get(arg);
                if (subCommand == null) {
                    messageMethod.accept("bad command:" + arg);
                    return true;
                }
                this.onCommand(callerId, parameterValues, subCommand);
                if (!permissionCheckMethod.test(subCommand.permission())) {
                    return false;
                }
                return subCommand.onCommand(callerId, permissionCheckMethod, messageMethod, Arrays.copyOfRange(args, i, args.length));
            }
            String paramName = argSplit[0].toLowerCase();
            CommandParameter currentParameter = this.getParameterLookup().get(paramName);
            if (currentParameter == null) {
                messageMethod.accept("bad parameter:" + argSplit[0]);
                continue;
            }
            parameterValues.put(paramName, argSplit[1]);
        }
        return true;
    }
}

