/*
 * Decompiled with CFR 0.152.
 */
package io.github.dailystruggle.effectsapi;

import io.github.dailystruggle.effectsapi.commandsapi.common.CommandsAPI;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.EnumMap;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class Effect<T extends Enum<T>>
extends BukkitRunnable
implements Cloneable {
    public final Class<T> persistentClass;
    protected Object target;
    protected EnumMap<T, Object> data;
    protected EnumMap<T, Object> defaults;

    public Effect(EnumMap<T, Object> defaults) throws IllegalArgumentException {
        this.defaults = defaults.clone();
        this.data = defaults.clone();
        this.persistentClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public EnumMap<T, Object> getData() {
        return this.data.clone();
    }

    public void setData(EnumMap<T, Object> data) throws IllegalArgumentException {
        this.data = data.clone();
        this.data = this.fixData(this.data);
    }

    public abstract String toPermission();

    public abstract void setData(String ... var1);

    public void setTarget(Object target) throws IllegalArgumentException {
        if (!(target instanceof Location) && !(target instanceof Entity)) {
            throw new IllegalArgumentException("target must be an entity or location");
        }
        this.target = target;
    }

    public EnumMap<T, Object> fixData(EnumMap<T, Object> data) {
        for (Map.Entry<T, Object> entry : this.defaults.entrySet()) {
            data.putIfAbsent((Enum)entry.getKey(), entry.getValue());
            Class<?> type = entry.getValue().getClass();
            Object val = data.get(entry.getKey());
            Object res = entry.getValue();
            if (!type.isAssignableFrom(val.getClass())) {
                Object object = val;
                if (object instanceof String) {
                    String string = (String)object;
                    res = this.str2Obj((Enum)entry.getKey(), string);
                } else if (res instanceof Color) {
                    String str = val.toString();
                    if (str.contains(String.valueOf(CommandsAPI.parameterDelimiter))) {
                        str = str.substring(str.indexOf(CommandsAPI.parameterDelimiter));
                    }
                    res = Color.fromRGB((int)Integer.parseInt(str, 16));
                } else {
                    try {
                        res = type.getMethod("valueOf", val.getClass()).invoke(null, val);
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e1) {
                        try {
                            res = type.getMethod("getByName", val.getClass()).invoke(null, val);
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e2) {
                            e2.printStackTrace();
                            continue;
                        }
                    }
                }
            }
            data.put((T)((Enum)entry.getKey()), res);
        }
        return data;
    }

    public Effect<T> clone() {
        try {
            Effect clone = (Effect)super.clone();
            clone.setData(this.data);
            if (this.target instanceof Location) {
                clone.target = ((Location)this.target).clone();
            }
            for (Map.Entry<T, Object> entry : this.data.entrySet()) {
                Object copy;
                Object o = entry.getValue();
                if (!(o instanceof Cloneable)) continue;
                try {
                    copy = o.getClass().getMethod("clone", o.getClass()).invoke(o, new Object[]{null});
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                    continue;
                }
                clone.data.put((T)((Enum)entry.getKey()), copy);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    private Object str2Obj(T key, String string) throws IllegalArgumentException {
        Object o;
        Object def = this.defaults.get(key);
        if (def instanceof String) {
            o = string;
        } else if (def instanceof Long || def instanceof Integer) {
            o = Long.parseLong(string);
        } else if (def instanceof Double || def instanceof Float) {
            o = Double.parseDouble(string) / 100.0;
        } else if (def instanceof Color) {
            o = Color.fromRGB((int)Integer.parseInt(string, 16));
        } else {
            try {
                o = def.getClass().getMethod("valueOf", String.class).invoke(null, string);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e1) {
                try {
                    o = def.getClass().getMethod("getByName", String.class).invoke(null, string);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e2) {
                    throw new IllegalArgumentException();
                }
            }
        }
        return o;
    }
}

