/*
 * Decompiled with CFR 0.152.
 */
package io.github.dailystruggle.effectsapi;

import io.github.dailystruggle.effectsapi.Effect;
import io.github.dailystruggle.effectsapi.LocalEffects.FireworkEffect;
import io.github.dailystruggle.effectsapi.LocalEffects.NoteEffect;
import io.github.dailystruggle.effectsapi.LocalEffects.ParticleEffect;
import io.github.dailystruggle.effectsapi.LocalEffects.PotionEffect;
import io.github.dailystruggle.effectsapi.LocalEffects.SoundEffect;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EffectFactory {
    private static final ConcurrentHashMap<String, Class<? extends Effect<?>>> effectMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, List<String>> initializedPermissions = new ConcurrentHashMap();

    public static void addEffect(String effectName, Class<? extends Effect<?>> effect) {
        effectMap.putIfAbsent(effectName.toUpperCase(), effect);
    }

    public static Enumeration<String> listEffects() {
        return effectMap.keys();
    }

    public static void removeEffect(String effectName) {
        effectMap.remove(effectName.toUpperCase());
    }

    @Nullable
    public static <T extends Enum<T>> Effect<T> buildEffect(String name) {
        Effect<?> effect;
        try {
            effect = effectMap.get(name.toUpperCase()).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
        return effect;
    }

    @Nullable
    public static <T extends Enum<T>> Effect<T> buildEffect(String name, EnumMap<T, Object> data) {
        Effect<T> effect = EffectFactory.buildEffect(name);
        if (effect == null) {
            return null;
        }
        effect.setData(data);
        return effect;
    }

    public static List<Effect<?>> buildEffects(@NotNull String permissionPrefix, @NotNull Collection<PermissionAttachmentInfo> permissions) {
        ArrayList res = new ArrayList();
        if (!((String)permissionPrefix).endsWith(".")) {
            permissionPrefix = (String)permissionPrefix + ".";
        }
        Bukkit.getLogger().severe("A");
        for (PermissionAttachmentInfo perm : permissions) {
            Effect<?> effect;
            Bukkit.getLogger().severe("B");
            if (!perm.getValue()) continue;
            Bukkit.getLogger().severe("C");
            String node = perm.getPermission();
            if (!node.startsWith((String)permissionPrefix)) continue;
            Bukkit.getLogger().severe("D");
            String[] val = node.replace((CharSequence)permissionPrefix, "").split("\\.");
            try {
                effect = effectMap.get(val[0].toUpperCase()).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                continue;
            }
            if (val.length > 1) {
                effect.setData(Arrays.copyOfRange(val, 1, val.length));
            }
            res.add(effect);
            Bukkit.getLogger().severe(effect.getData().toString());
        }
        Bukkit.getLogger().severe("E");
        return res;
    }

    public static void addPermissions(String permissionPrefix) {
        if (!((String)permissionPrefix).endsWith(".")) {
            permissionPrefix = (String)permissionPrefix + ".";
        }
        for (String name : effectMap.keySet()) {
            PotionEffectType key;
            int n;
            PotionEffectType[] o;
            Object[] objectArray;
            Effect effect = EffectFactory.buildEffect(name);
            Enum[] enumConstants = (Enum[])Objects.requireNonNull(effect).persistentClass.getEnumConstants();
            HashMap<String, Enum> enumMap = new HashMap<String, Enum>();
            if (enumConstants.length < 50) {
                for (Enum e : enumConstants) {
                    enumMap.put(e.name().toUpperCase(), e);
                }
            }
            if ((objectArray = (o = effect.getData().get(enumMap.get("TYPE")))) instanceof Enum) {
                Enum e = (Enum)objectArray;
                objectArray = (Enum[])e.getClass().getEnumConstants();
                int n2 = objectArray.length;
                for (n = 0; n < n2; ++n) {
                    key = objectArray[n];
                    Bukkit.getPluginManager().addPermission(new Permission((String)permissionPrefix + name + "." + (Enum)key));
                }
                continue;
            }
            if (!(o instanceof PotionEffectType)) continue;
            objectArray = PotionEffectType.values();
            int n3 = objectArray.length;
            for (n = 0; n < n3; ++n) {
                key = objectArray[n];
                Bukkit.getPluginManager().addPermission(new Permission((String)permissionPrefix + name + "." + key));
            }
        }
    }

    static {
        EffectFactory.addEffect("FIREWORK", FireworkEffect.class);
        EffectFactory.addEffect("NOTE", NoteEffect.class);
        EffectFactory.addEffect("PARTICLE", ParticleEffect.class);
        EffectFactory.addEffect("POTION", PotionEffect.class);
        EffectFactory.addEffect("SOUND", SoundEffect.class);
    }
}

