/*
 * Decompiled with CFR 0.152.
 */
package io.github.dailystruggle.effectsapi.LocalEffects;

import io.github.dailystruggle.effectsapi.Effect;
import io.github.dailystruggle.effectsapi.LocalEffects.enums.FireworkTypeNames;
import io.github.dailystruggle.effectsapi.SpigotListeners.FireworkSafetyListener;
import java.util.EnumMap;
import java.util.Objects;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.util.Vector;

public class FireworkEffect
extends Effect<FireworkTypeNames> {
    public FireworkEffect() {
        super(new EnumMap(FireworkTypeNames.class));
        EnumMap data = this.getData();
        data.put(FireworkTypeNames.TYPE, (Object)FireworkEffect.Type.BALL);
        data.put(FireworkTypeNames.NUMBER, 1);
        data.put(FireworkTypeNames.POWER, 0);
        data.put(FireworkTypeNames.DX, 0.0);
        data.put(FireworkTypeNames.DY, 1.0);
        data.put(FireworkTypeNames.DZ, 0.0);
        data.put(FireworkTypeNames.COLOR, (Object)Color.WHITE);
        data.put(FireworkTypeNames.FADE, (Object)Color.WHITE);
        data.put(FireworkTypeNames.FLICKER, false);
        data.put(FireworkTypeNames.TRAIL, false);
        data.put(FireworkTypeNames.SAFE, true);
        this.data = data;
        this.defaults = data.clone();
    }

    public void run() {
        if (this.target instanceof Entity) {
            this.target = ((Entity)this.target).getLocation();
        }
        Location location = (Location)this.target;
        int numFireworks = (Integer)this.data.get((Object)FireworkTypeNames.NUMBER);
        double dx = (Double)this.data.get((Object)FireworkTypeNames.DX);
        double dy = (Double)this.data.get((Object)FireworkTypeNames.DY);
        double dz = (Double)this.data.get((Object)FireworkTypeNames.DZ);
        Firework f = (Firework)Objects.requireNonNull(location.getWorld()).spawnEntity(location.clone().add(0.0, 1.0, 0.0), EntityType.FIREWORK);
        if (dx != 0.0 || dy != 1.0 || dz != 0.0) {
            f.setShotAtAngle(true);
            f.setVelocity(new Vector(dx, dy, dz));
        }
        FireworkMeta fwm = f.getFireworkMeta();
        org.bukkit.FireworkEffect fireworkEffect = org.bukkit.FireworkEffect.builder().with((FireworkEffect.Type)this.data.get((Object)FireworkTypeNames.TYPE)).withColor((Color)this.data.get((Object)FireworkTypeNames.COLOR)).withFade((Color)this.data.get((Object)FireworkTypeNames.FADE)).flicker(((Boolean)this.data.get((Object)FireworkTypeNames.FLICKER)).booleanValue()).trail(((Boolean)this.data.get((Object)FireworkTypeNames.TRAIL)).booleanValue()).build();
        fwm.addEffect(fireworkEffect);
        fwm.setPower(((Integer)this.data.get((Object)FireworkTypeNames.POWER)).intValue());
        f.setFireworkMeta(fwm);
        boolean safe = (Boolean)this.data.get((Object)FireworkTypeNames.SAFE);
        if (numFireworks > 1) {
            FireworkSafetyListener.addFirework(f.getEntityId(), numFireworks, safe);
        }
        if (fwm.getPower() == 0) {
            f.detonate();
        }
    }

    @Override
    public void setData(String ... data) {
        if (data.length > 0) {
            this.data.put(FireworkTypeNames.TYPE, data[0]);
        }
        if (data.length > 1) {
            this.data.put(FireworkTypeNames.NUMBER, data[1]);
        }
        if (data.length > 2) {
            this.data.put(FireworkTypeNames.POWER, data[2]);
        }
        if (data.length > 3) {
            this.data.put(FireworkTypeNames.COLOR, data[3]);
        }
        if (data.length > 4) {
            this.data.put(FireworkTypeNames.FADE, data[4]);
        }
        if (data.length > 5) {
            this.data.put(FireworkTypeNames.FLICKER, data[5]);
        }
        if (data.length > 6) {
            this.data.put(FireworkTypeNames.TRAIL, data[6]);
        }
        if (data.length > 7) {
            this.data.put(FireworkTypeNames.SAFE, data[7]);
        }
        if (data.length > 8) {
            this.data.put(FireworkTypeNames.DX, data[8]);
        }
        if (data.length > 9) {
            this.data.put(FireworkTypeNames.DY, data[9]);
        }
        if (data.length > 10) {
            this.data.put(FireworkTypeNames.DZ, data[10]);
        }
        this.data = this.fixData(this.data);
    }

    @Override
    public String toPermission() {
        return this.data.get((Object)FireworkTypeNames.TYPE).toString().replaceAll("\\.*", "") + this.data.get((Object)FireworkTypeNames.NUMBER).toString().replaceAll("\\.*", "") + this.data.get((Object)FireworkTypeNames.POWER).toString().replaceAll("\\.*", "") + this.data.get((Object)FireworkTypeNames.COLOR).toString().replaceAll("\\.*", "") + this.data.get((Object)FireworkTypeNames.FADE).toString().replaceAll("\\.*", "") + this.data.get((Object)FireworkTypeNames.FLICKER).toString().replaceAll("\\.*", "") + this.data.get((Object)FireworkTypeNames.TRAIL).toString().replaceAll("\\.*", "") + this.data.get((Object)FireworkTypeNames.SAFE).toString().replaceAll("\\.*", "") + this.data.get((Object)FireworkTypeNames.DX).toString().replaceAll("\\.*", "") + this.data.get((Object)FireworkTypeNames.DY).toString().replaceAll("\\.*", "") + this.data.get((Object)FireworkTypeNames.DZ).toString().replaceAll("\\.*", "");
    }
}

