/*
 * Decompiled with CFR 0.152.
 */
package io.github.dailystruggle.effectsapi.LocalEffects;

import io.github.dailystruggle.effectsapi.Effect;
import io.github.dailystruggle.effectsapi.LocalEffects.enums.NoteTypeNames;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.NoteBlock;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class NoteEffect
extends Effect<NoteTypeNames> {
    private BukkitTask makeNoteSoundTask = null;
    private BukkitTask cleanupTask = null;
    private BlockData oldBlockData;

    public NoteEffect() throws IllegalArgumentException {
        super(new EnumMap(NoteTypeNames.class));
        EnumMap data = this.getData();
        data.put(NoteTypeNames.TYPE, (Object)Instrument.PIANO);
        data.put(NoteTypeNames.TONE, 0);
        this.data = data;
        this.defaults = data.clone();
    }

    public void run() {
        if (this.target instanceof Entity) {
            this.target = ((Entity)this.target).getLocation();
        }
        NoteBlock noteData = (NoteBlock)Bukkit.createBlockData((Material)Material.NOTE_BLOCK);
        noteData.setInstrument((Instrument)this.data.get((Object)NoteTypeNames.TYPE));
        noteData.setNote(new Note(((Integer)this.data.get((Object)NoteTypeNames.TONE)).intValue()));
        Block block = ((Location)this.target).getBlock();
        this.oldBlockData = block.getBlockData().clone();
        block.setBlockData((BlockData)noteData);
    }

    @NotNull
    public synchronized BukkitTask runTask(@NotNull Plugin plugin) {
        BukkitTask res = super.runTask(plugin);
        this.makeNoteSoundTask = new MakeNoteSound().runTaskLater(plugin, 1L);
        this.cleanupTask = new Cleanup().runTaskLater(plugin, 2L);
        return res;
    }

    public void cancel() {
        if (this.makeNoteSoundTask != null) {
            this.makeNoteSoundTask.cancel();
        }
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel();
        }
    }

    @Override
    public void setData(String ... data) {
        if (data.length > 0) {
            this.data.put(NoteTypeNames.TYPE, data[0]);
        }
        if (data.length > 1) {
            this.data.put(NoteTypeNames.TONE, data[1]);
        }
        this.data = this.fixData(this.data);
    }

    @Override
    public String toPermission() {
        return this.data.get((Object)NoteTypeNames.TYPE).toString().replaceAll("\\.*", "") + this.data.get((Object)NoteTypeNames.TONE).toString().replaceAll("\\.*", "");
    }

    private final class MakeNoteSound
    extends BukkitRunnable {
        private MakeNoteSound() {
        }

        public void run() {
            Location location = (Location)NoteEffect.this.target;
            List players = Objects.requireNonNull(location.getWorld()).getPlayers().parallelStream().filter(player -> player.getLocation().distance(location) < 48.0).collect(Collectors.toList());
            for (Player player2 : players) {
                player2.playNote(location, (Instrument)NoteEffect.this.data.get((Object)NoteTypeNames.TYPE), new Note(((Integer)NoteEffect.this.data.get((Object)NoteTypeNames.TONE)).intValue()));
            }
            NoteEffect.this.makeNoteSoundTask = null;
        }
    }

    private final class Cleanup
    extends BukkitRunnable {
        private Cleanup() {
        }

        public void run() {
            Location location = (Location)NoteEffect.this.target;
            location.getBlock().setBlockData(NoteEffect.this.oldBlockData);
            NoteEffect.this.cleanupTask = null;
        }
    }
}

