/*
 * Decompiled with CFR 0.152.
 */
package io.github.dailystruggle.effectsapi.LocalEffects;

import io.github.dailystruggle.effectsapi.Effect;
import io.github.dailystruggle.effectsapi.LocalEffects.enums.PotionTypeNames;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class PotionEffect
extends Effect<PotionTypeNames> {
    public PotionEffect() throws IllegalArgumentException {
        super(new EnumMap(PotionTypeNames.class));
        EnumMap data = this.getData();
        data.put(PotionTypeNames.TYPE, (Object)FireworkEffect.Type.BALL);
        data.put(PotionTypeNames.DURATION, 1);
        data.put(PotionTypeNames.AMPLIFIER, 1);
        data.put(PotionTypeNames.AMBIENT, false);
        data.put(PotionTypeNames.PARTICLES, true);
        data.put(PotionTypeNames.ICON, true);
        this.data = data;
        this.defaults = data.clone();
    }

    public void run() {
        org.bukkit.potion.PotionEffect potionEffect = new org.bukkit.potion.PotionEffect((PotionEffectType)this.data.get((Object)PotionTypeNames.TYPE), ((Integer)this.data.get((Object)PotionTypeNames.DURATION)).intValue(), ((Integer)this.data.get((Object)PotionTypeNames.AMPLIFIER)).intValue(), ((Boolean)this.data.get((Object)PotionTypeNames.AMBIENT)).booleanValue(), ((Boolean)this.data.get((Object)PotionTypeNames.PARTICLES)).booleanValue(), ((Boolean)this.data.get((Object)PotionTypeNames.ICON)).booleanValue());
        if (this.target instanceof Player) {
            ((Player)this.target).addPotionEffect(potionEffect);
        } else {
            if (this.target instanceof Entity) {
                this.target = ((Entity)this.target).getLocation();
            }
            Location location = (Location)this.target;
            List players = Objects.requireNonNull(location.getWorld()).getPlayers().parallelStream().filter(player -> player.getLocation().distance(location) < 48.0).collect(Collectors.toList());
            for (Player player2 : players) {
                player2.addPotionEffect(potionEffect);
            }
        }
    }

    @Override
    public String toPermission() {
        return this.data.get((Object)PotionTypeNames.TYPE).toString().replaceAll("\\.*", "") + this.data.get((Object)PotionTypeNames.DURATION).toString().replaceAll("\\.*", "") + this.data.get((Object)PotionTypeNames.AMPLIFIER).toString().replaceAll("\\.*", "") + this.data.get((Object)PotionTypeNames.AMBIENT).toString().replaceAll("\\.*", "") + this.data.get((Object)PotionTypeNames.PARTICLES).toString().replaceAll("\\.*", "") + this.data.get((Object)PotionTypeNames.ICON).toString().replaceAll("\\.*", "");
    }

    @Override
    public void setData(String ... data) {
        if (data.length > 0) {
            this.data.put(PotionTypeNames.TYPE, data[0]);
        }
        if (data.length > 1) {
            this.data.put(PotionTypeNames.AMPLIFIER, data[1]);
        }
        if (data.length > 2) {
            this.data.put(PotionTypeNames.AMBIENT, data[2]);
        }
        if (data.length > 3) {
            this.data.put(PotionTypeNames.PARTICLES, data[3]);
        }
        if (data.length > 4) {
            this.data.put(PotionTypeNames.ICON, data[4]);
        }
        this.data = this.fixData(this.data);
    }
}

