/*
 * Decompiled with CFR 0.152.
 */
package io.github.dailystruggle.effectsapi.SpigotListeners;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FireworkExplodeEvent;
import org.bukkit.plugin.Plugin;

public class FireworkSafetyListener
implements Listener {
    private static final ConcurrentHashMap<Integer, FireworkDetonation> fireworkDetonations = new ConcurrentHashMap();
    private static final ConcurrentSkipListSet<Integer> safeEntities = new ConcurrentSkipListSet();
    private final Plugin caller;

    public FireworkSafetyListener(Plugin caller) {
        this.caller = caller;
    }

    public static void addFirework(Integer fireworkId, Integer numExplosions, Boolean isSafe) {
        FireworkDetonation res = fireworkDetonations.put(fireworkId, new FireworkDetonation(fireworkId, numExplosions, isSafe));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onFireworkExplode(FireworkExplodeEvent event) {
        Integer fireworkId = event.getEntity().getEntityId();
        FireworkDetonation fireworkDetonation = fireworkDetonations.get(fireworkId);
        if (fireworkDetonation == null) {
            return;
        }
        if (fireworkDetonation.isSafe.booleanValue()) {
            List entities = event.getEntity().getNearbyEntities(5.0, 5.0, 5.0);
            for (Entity entity : entities) {
                safeEntities.add(entity.getEntityId());
            }
            Bukkit.getScheduler().runTaskLater(this.caller, () -> {
                for (Entity entity : entities) {
                    safeEntities.remove(entity.getEntityId());
                }
            }, 1L);
        }
        fireworkDetonations.remove(fireworkId);
        Location location = event.getEntity().getLocation();
        for (int i = 1; i < fireworkDetonation.numExplosions; ++i) {
            Firework firework = (Firework)location.getWorld().spawnEntity(location, event.getEntityType());
            firework.setFireworkMeta(event.getEntity().getFireworkMeta());
            firework.detonate();
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onFireworkDamage(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getCause().equals((Object)EntityDamageEvent.DamageCause.ENTITY_EXPLOSION)) {
            return;
        }
        if (safeEntities.contains(event.getEntity().getEntityId())) {
            event.setCancelled(true);
        }
    }

    private static class FireworkDetonation
    implements Comparable<FireworkDetonation> {
        public Integer fireworkId;
        public Integer numExplosions;
        public Boolean isSafe;

        public FireworkDetonation() {
        }

        public FireworkDetonation(Integer fireworkId) {
            this.fireworkId = fireworkId;
            this.numExplosions = 1;
            this.isSafe = false;
        }

        public FireworkDetonation(Integer fireworkId, Integer numExplosions, Boolean isSafe) {
            this.fireworkId = fireworkId;
            this.numExplosions = numExplosions;
            this.isSafe = isSafe;
        }

        @Override
        public int compareTo(FireworkDetonation o) {
            return this.fireworkId.compareTo(o.fireworkId);
        }
    }
}

