/*
 * Decompiled with CFR 0.152.
 */
package io.github.dailystruggle.effectsapi.commands;

import io.github.dailystruggle.effectsapi.LocalEffects.FireworkEffect;
import io.github.dailystruggle.effectsapi.LocalEffects.enums.FireworkTypeNames;
import io.github.dailystruggle.effectsapi.commands.GenericEffectCommand;
import io.github.dailystruggle.effectsapi.commandsapi.common.CommandsAPICommand;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FireworkCommand
extends GenericEffectCommand<FireworkEffect> {
    public FireworkCommand(Plugin plugin) {
        super(plugin);
    }

    @Override
    public boolean onCommand(CommandSender sender, Map<String, List<String>> parameterValues, CommandsAPICommand nextCommand) {
        if (!(sender instanceof Player)) {
            return false;
        }
        ArrayList<FireworkEffect> effects = new ArrayList<FireworkEffect>();
        FireworkEffect mainEffect = new FireworkEffect();
        effects.add(mainEffect);
        mainEffect.setTarget(sender);
        EnumMap data = mainEffect.getData();
        for (Map.Entry<String, List<String>> entry : parameterValues.entrySet()) {
            List<String> vals = entry.getValue();
            String name = entry.getKey().toLowerCase();
            FireworkTypeNames enumLookup = FireworkTypeNames.valueOf(name.toUpperCase());
            String value = entry.getValue().get(0);
            data.put(enumLookup, (Object)value);
            mainEffect.setData(data);
            while (effects.size() < vals.size()) {
                effects.add(new FireworkEffect());
            }
            for (int i = 1; i < vals.size(); ++i) {
                FireworkEffect effect = (FireworkEffect)effects.get(i);
                enumLookup = FireworkTypeNames.valueOf(name.toUpperCase());
                value = entry.getValue().get(i);
                data.put(enumLookup, (Object)value);
                effect.setData(data);
            }
        }
        for (FireworkEffect effect : effects) {
            effect.runTask(this.plugin);
        }
        return true;
    }

    @Override
    public String name() {
        return "firework";
    }

    @Override
    public String permission() {
        return "effectsapi.test";
    }
}

