/*
 * Decompiled with CFR 0.152.
 */
package io.github.dailystruggle.effectsapi.commands;

import io.github.dailystruggle.effectsapi.Effect;
import io.github.dailystruggle.effectsapi.commandsapi.bukkit.BukkitParameter;
import io.github.dailystruggle.effectsapi.commandsapi.bukkit.LocalParameters.BooleanParameter;
import io.github.dailystruggle.effectsapi.commandsapi.bukkit.LocalParameters.ColorParameter;
import io.github.dailystruggle.effectsapi.commandsapi.bukkit.LocalParameters.FloatParameter;
import io.github.dailystruggle.effectsapi.commandsapi.bukkit.LocalParameters.IntegerParameter;
import io.github.dailystruggle.effectsapi.commandsapi.bukkit.LocalParameters.PotionParameter;
import io.github.dailystruggle.effectsapi.commandsapi.bukkit.localCommands.BukkitTreeCommand;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public abstract class GenericEffectCommand<T extends Effect<?>>
extends BukkitTreeCommand {
    protected final Class<T> persistentClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    public GenericEffectCommand(Plugin plugin) {
        super(plugin, null);
        Effect effect;
        try {
            effect = (Effect)this.persistentClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return;
        }
        for (Map.Entry entry : effect.getData().entrySet()) {
            Object val = entry.getValue();
            if (val instanceof Integer || val instanceof Long) {
                this.addParameter(((Enum)entry.getKey()).toString().toLowerCase(), new IntegerParameter("effectsapi.see", "", (sender1, s) -> true, 0, 1));
                continue;
            }
            if (val instanceof Float || val instanceof Double) {
                this.addParameter(((Enum)entry.getKey()).toString().toLowerCase(), new FloatParameter("effectsapi.see", "", (sender1, s) -> true, 0.0, 1.0));
                continue;
            }
            if (val instanceof Boolean) {
                this.addParameter(((Enum)entry.getKey()).toString().toLowerCase(), new BooleanParameter("effectsapi.see", "", (sender1, s) -> true));
                continue;
            }
            if (val instanceof Color) {
                this.addParameter(((Enum)entry.getKey()).toString().toLowerCase(), new ColorParameter("effectsapi.see", "", (sender1, s) -> true));
                continue;
            }
            if (val instanceof PotionEffectType) {
                this.addParameter(((Enum)entry.getKey()).toString().toLowerCase(), new PotionParameter("effectsapi.see", "", (sender1, s) -> true));
                continue;
            }
            if (val instanceof Enum) {
                final Class<?> enumClass = val.getClass();
                this.addParameter(((Enum)entry.getKey()).toString().toLowerCase(), new BukkitParameter("effectsapi.see", "", (sender1, s) -> true){
                    private final Set<String> values;
                    {
                        super(arg0, arg1, arg2);
                        this.values = Arrays.stream((Enum[])enumClass.getEnumConstants()).map(Enum::name).collect(Collectors.toSet());
                    }

                    @Override
                    public Set<String> values() {
                        return this.values;
                    }
                });
                continue;
            }
            throw new IllegalArgumentException("bad type for - " + val);
        }
    }

    @Override
    public String description() {
        return "";
    }

    @Override
    public void msgBadParameter(UUID callerId, String parameterName, String parameterValue) {
    }
}

