/*
 * Decompiled with CFR 0.152.
 */
package io.github.dailystruggle.effectsapi.commands;

import io.github.dailystruggle.effectsapi.LocalEffects.PotionEffect;
import io.github.dailystruggle.effectsapi.LocalEffects.enums.PotionTypeNames;
import io.github.dailystruggle.effectsapi.commands.GenericEffectCommand;
import io.github.dailystruggle.effectsapi.commandsapi.common.CommandsAPICommand;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class PotionCommand
extends GenericEffectCommand<PotionEffect> {
    public PotionCommand(Plugin plugin) {
        super(plugin);
    }

    @Override
    public String name() {
        return "potion";
    }

    @Override
    public String permission() {
        return "EffectsAPI.test";
    }

    @Override
    public boolean onCommand(CommandSender sender, Map<String, List<String>> parameterValues, CommandsAPICommand nextCommand) {
        PotionEffect mainEffect = new PotionEffect();
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        effects.add(mainEffect);
        mainEffect.setTarget(sender);
        EnumMap data = mainEffect.getData();
        int longest = 1;
        for (Map.Entry<String, List<String>> entry : parameterValues.entrySet()) {
            String name = entry.getKey().toLowerCase();
            List<String> vals = entry.getValue();
            PotionTypeNames enumLookup = PotionTypeNames.valueOf(name.toUpperCase());
            String value = entry.getValue().get(0);
            data.put(enumLookup, (Object)value);
            longest = Math.max(longest, vals.size());
            while (effects.size() < vals.size()) {
                effects.add(new PotionEffect());
            }
            for (int i = 1; i < vals.size(); ++i) {
                PotionEffect effect = (PotionEffect)effects.get(i);
                enumLookup = PotionTypeNames.valueOf(name.toUpperCase());
                value = entry.getValue().get(i);
                data.put(enumLookup, (Object)value);
                effect.setData(data);
            }
        }
        mainEffect.setData(data);
        for (PotionEffect effect : effects) {
            effect.runTask(this.plugin);
        }
        return true;
    }
}

