/*
 * Decompiled with CFR 0.152.
 */
package io.github.dailystruggle.effectsapi.commandsapi.bukkit.LocalParameters;

import io.github.dailystruggle.effectsapi.commandsapi.bukkit.BukkitParameter;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;

public class FloatParameter
extends BukkitParameter {
    Set<String> allValues;

    public FloatParameter(String permission, String description, BiFunction<CommandSender, String, Boolean> isRelevant, Vector<Double> range) {
        super(permission, description, isRelevant);
        this.allValues = new HashSet<String>();
        int maxSteps = range.size() > 2 ? range.get(1).intValue() : 20;
        double span = range.lastElement() - range.firstElement();
        double step = span / (double)maxSteps;
        DecimalFormat decimalFormat = new DecimalFormat("###.##");
        double i = range.firstElement();
        while (i < range.lastElement()) {
            this.allValues.add(String.valueOf(decimalFormat.format(i)));
            i = step > 1.0 ? i + 1.0 : i + step;
        }
    }

    public FloatParameter(String permission, String description, BiFunction<CommandSender, String, Boolean> isRelevant, Object ... options) {
        super(permission, description, isRelevant);
        DecimalFormat decimalFormat = new DecimalFormat("###.##");
        this.allValues = Arrays.stream(options).map(decimalFormat::format).collect(Collectors.toSet());
    }

    @Override
    public Set<String> values() {
        return this.allValues;
    }
}

