/*
 * Decompiled with CFR 0.152.
 */
package io.github.dailystruggle.effectsapi.commandsapi.bukkit.LocalParameters;

import io.github.dailystruggle.effectsapi.commandsapi.bukkit.BukkitParameter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;

public class IntegerParameter
extends BukkitParameter {
    Set<String> allValues;

    public IntegerParameter(String permission, String description, BiFunction<CommandSender, String, Boolean> isRelevant, Vector<Integer> range) {
        super(permission, description, isRelevant);
        this.allValues = new HashSet<String>();
        int maxSteps = 20;
        double span = range.lastElement() - range.firstElement();
        double step = span / (double)maxSteps;
        double i = range.firstElement().intValue();
        while (i < (double)range.lastElement().intValue()) {
            this.allValues.add(String.valueOf((int)i));
            i = step > 1.0 ? i + 1.0 : i + step;
        }
    }

    public IntegerParameter(String permission, String description, BiFunction<CommandSender, String, Boolean> isRelevant, Object ... options) {
        super(permission, description, isRelevant);
        this.allValues = Arrays.stream(options).map(String::valueOf).collect(Collectors.toSet());
    }

    @Override
    public Set<String> values() {
        return this.allValues;
    }
}

