/*
 * Decompiled with CFR 0.152.
 */
package io.github.dailystruggle.effectsapi.commandsapi.bukkit.localCommands;

import io.github.dailystruggle.effectsapi.commandsapi.bukkit.BukkitCommand;
import io.github.dailystruggle.effectsapi.commandsapi.common.CommandParameter;
import io.github.dailystruggle.effectsapi.commandsapi.common.CommandsAPI;
import io.github.dailystruggle.effectsapi.commandsapi.common.CommandsAPICommand;
import io.github.dailystruggle.effectsapi.commandsapi.common.localCommands.TreeCommand;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public abstract class BukkitTreeCommand
extends BukkitCommand
implements TreeCommand {
    protected long avgTime = 0L;
    protected final Map<String, CommandParameter> parameterLookup = new ConcurrentHashMap<String, CommandParameter>();
    private final CommandsAPICommand parent;
    protected final Map<String, CommandsAPICommand> commandLookup = new ConcurrentHashMap<String, CommandsAPICommand>();

    public BukkitTreeCommand(Plugin plugin, @Nullable CommandsAPICommand parent) {
        super(plugin);
        StringBuilder name = new StringBuilder(this.name());
        for (CommandsAPICommand p = parent; p != null; p = p.parent()) {
            name.insert(0, p.name() + " ");
        }
        PluginCommand command = Bukkit.getPluginCommand((String)name.toString());
        if (command != null) {
            command.setExecutor((CommandExecutor)this);
            command.setTabCompleter((TabCompleter)this);
        }
        this.parent = parent;
    }

    @Override
    public CommandsAPICommand parent() {
        return this.parent;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        UUID senderId;
        if (sender instanceof Player) {
            senderId = ((Player)sender).getUniqueId();
        } else if (sender.getName().equals(Bukkit.getConsoleSender().getName())) {
            senderId = CommandsAPI.serverId;
        } else {
            sender.sendMessage("alternate command senders not currently supported");
            return false;
        }
        return this.onCommand(senderId, arg_0 -> ((CommandSender)sender).hasPermission(arg_0), arg_0 -> ((CommandSender)sender).sendMessage(arg_0), args);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        UUID senderId;
        if (sender instanceof Player) {
            senderId = ((Player)sender).getUniqueId();
        } else if (sender.getName().equals(Bukkit.getConsoleSender().getName())) {
            senderId = CommandsAPI.serverId;
        } else {
            return null;
        }
        return this.onTabComplete(senderId, arg_0 -> ((CommandSender)sender).hasPermission(arg_0), args);
    }

    @Override
    public boolean onCommand(UUID callerId, Map<String, List<String>> parameterValues, CommandsAPICommand nextCommand) {
        ConsoleCommandSender commandSender;
        if (callerId.equals(CommandsAPI.serverId)) {
            commandSender = Bukkit.getConsoleSender();
        } else {
            commandSender = Bukkit.getPlayer((UUID)callerId);
            if (commandSender == null) {
                return false;
            }
        }
        boolean res = this.onCommand((CommandSender)commandSender, parameterValues, nextCommand);
        long stop = System.nanoTime();
        return res;
    }

    public abstract boolean onCommand(CommandSender var1, Map<String, List<String>> var2, CommandsAPICommand var3);

    @Override
    public Map<String, CommandParameter> getParameterLookup() {
        return this.parameterLookup;
    }

    @Override
    public Map<String, CommandsAPICommand> getCommandLookup() {
        return this.commandLookup;
    }

    @Override
    public long avgTime() {
        return this.avgTime;
    }
}

