/*
 * Decompiled with CFR 0.152.
 */
package io.github.dailystruggle.effectsapi.commandsapi.common;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public abstract class CommandParameter {
    public Map<String, Map<String, CommandParameter>> subParamMap = new ConcurrentHashMap<String, Map<String, CommandParameter>>();
    public BiFunction<UUID, String, Boolean> isRelevant;
    private final String permission;
    private final String description;

    public CommandParameter(String permission, String description, BiFunction<UUID, String, Boolean> isRelevant) {
        this.isRelevant = isRelevant;
        this.permission = permission;
        this.description = description;
    }

    public abstract Set<String> values();

    public String permission() {
        return this.permission;
    }

    public String description() {
        return this.description;
    }

    public Set<String> relevantValues(UUID senderId) {
        return this.values().stream().filter(s -> this.isRelevant.apply(senderId, (String)s)).collect(Collectors.toSet());
    }

    public Map<String, CommandParameter> subParams(String parameter) {
        return this.subParamMap.get(parameter);
    }
}

