/*
 * Decompiled with CFR 0.152.
 */
package io.github.dailystruggle.effectsapi.commandsapi.common;

import io.github.dailystruggle.effectsapi.commandsapi.common.CommandExecutor;
import io.github.dailystruggle.effectsapi.commandsapi.common.Factory;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

public class CommandsAPI {
    public static char parameterDelimiter = (char)58;
    public static char multiParameterDelimiter = (char)44;
    public static final UUID serverId = new UUID(0L, 0L);
    public static final Factory commandFactory = new Factory();
    public static final Factory parameterFactory = new Factory();
    public static final ConcurrentLinkedQueue<CommandExecutor> commandPipeline = new ConcurrentLinkedQueue();

    public static long execute() {
        return CommandsAPI.execute(TimeUnit.MILLISECONDS.toNanos(50L));
    }

    public static long execute(long availableTime) {
        long avgTime;
        long dt;
        if (commandPipeline.size() == 0) {
            return 0L;
        }
        long start = System.nanoTime();
        do {
            CommandExecutor commandExecutor = commandPipeline.poll();
            avgTime = Objects.requireNonNull(commandExecutor).command().avgTime();
            commandExecutor.run();
            long t = System.nanoTime();
            if (t < start) {
                start = -(Long.MAX_VALUE - start);
            }
            dt = t - start;
        } while (commandPipeline.size() > 0 && dt + avgTime < availableTime);
        return commandPipeline.size();
    }
}

