/*
 * Decompiled with CFR 0.152.
 */
package io.github.dailystruggle.effectsapi.commandsapi.common.localCommands;

import io.github.dailystruggle.effectsapi.commandsapi.common.CommandExecutor;
import io.github.dailystruggle.effectsapi.commandsapi.common.CommandParameter;
import io.github.dailystruggle.effectsapi.commandsapi.common.CommandsAPI;
import io.github.dailystruggle.effectsapi.commandsapi.common.CommandsAPICommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TreeCommand
extends CommandsAPICommand {
    default public void addParameter(String name, CommandParameter parameter) {
        this.getParameterLookup().put(name.toLowerCase(), parameter);
    }

    default public void addSubCommand(CommandsAPICommand command) {
        this.getCommandLookup().put(command.name().toUpperCase(), command);
    }

    public Map<String, CommandParameter> getParameterLookup();

    public Map<String, CommandsAPICommand> getCommandLookup();

    @NotNull
    default public List<String> onTabComplete(@NotNull UUID callerId, @NotNull Predicate<String> permissionCheckMethod, @NotNull String[] args) {
        return this.onTabComplete(callerId, permissionCheckMethod, args, 0, null);
    }

    @Override
    @NotNull
    default public List<String> onTabComplete(@NotNull UUID callerId, @NotNull Predicate<String> permissionCheckMethod, @NotNull String[] args, int i, @Nullable Map<String, CommandParameter> tempParameters) {
        if (tempParameters == null) {
            tempParameters = new HashMap<String, CommandParameter>();
        }
        HashSet<String> parameterValues = new HashSet<String>();
        ArrayList<String> possibleResults = new ArrayList<String>();
        Map<String, CommandParameter> parameterLookup = this.getParameterLookup();
        while (i < args.length && args[i].contains(String.valueOf(CommandsAPI.parameterDelimiter))) {
            if (i < args.length - 1) {
                String[] arr = args[i].split(String.valueOf(CommandsAPI.parameterDelimiter));
                parameterValues.add(arr[0]);
                CommandParameter parameter = parameterLookup.get(arr[0]);
                if (parameter == null) {
                    parameter = tempParameters.get(arr[0]);
                }
                if (parameter != null && arr.length > 1) {
                    Iterator<Object> subParameters;
                    for (Iterator<Object> subParamName : subParameters = arr[1].split(String.valueOf(CommandsAPI.multiParameterDelimiter))) {
                        Map<String, CommandParameter> parameterMap = parameter.subParams((String)((Object)subParamName));
                        if (parameterMap == null) continue;
                        tempParameters.putAll(parameterMap);
                    }
                }
            }
            ++i;
        }
        if (i == args.length) {
            if (i > 0) {
                int delimiterIdx;
                String arg;
                String string = arg = (delimiterIdx = args[--i].indexOf(CommandsAPI.parameterDelimiter)) > 0 ? args[i].substring(0, delimiterIdx) : args[i];
                if (delimiterIdx < 0) {
                    String permission;
                    for (Map.Entry<String, CommandParameter> entry : parameterLookup.entrySet()) {
                        String key = entry.getKey();
                        CommandParameter value = entry.getValue();
                        if (key == null || value == null) continue;
                        permission = value.permission();
                        if (parameterValues.contains(key) || permission != null && !permissionCheckMethod.test(permission)) continue;
                        possibleResults.add(key + CommandsAPI.parameterDelimiter);
                    }
                    for (Map.Entry<String, CommandParameter> entry : tempParameters.entrySet()) {
                        String key = entry.getKey();
                        CommandParameter value = entry.getValue();
                        if (key == null || value == null) continue;
                        permission = value.permission();
                        if (parameterValues.contains(key) || permission != null && !permissionCheckMethod.test(permission)) continue;
                        possibleResults.add(key + CommandsAPI.parameterDelimiter);
                    }
                    for (CommandsAPICommand command : this.getCommandLookup().values()) {
                        if (!permissionCheckMethod.test(command.permission())) continue;
                        possibleResults.add(command.name());
                    }
                } else if (parameterLookup.containsKey(arg)) {
                    if (parameterValues.contains(arg)) {
                        return new ArrayList<String>();
                    }
                    val = args[i].substring(delimiterIdx + 1);
                    vals = Arrays.stream(val.split(String.valueOf(CommandsAPI.multiParameterDelimiter))).collect(Collectors.toSet());
                    CommandParameter parameter = parameterLookup.get(arg);
                    List<String> relevantValues = new ArrayList<String>(parameter.relevantValues(callerId));
                    front = args[i].contains(String.valueOf(CommandsAPI.multiParameterDelimiter)) ? args[i].substring(0, args[i].lastIndexOf(CommandsAPI.multiParameterDelimiter)) + CommandsAPI.multiParameterDelimiter : arg + CommandsAPI.parameterDelimiter;
                    relevantValues = relevantValues.stream().filter(s -> !vals.contains(s)).map(s -> front + s).collect(Collectors.toList());
                    possibleResults.addAll(relevantValues);
                    for (String v : vals) {
                        Map<String, CommandParameter> subParams = parameter.subParams(v);
                        if (subParams == null) continue;
                        tempParameters.putAll(subParams);
                    }
                } else if (tempParameters.containsKey(arg)) {
                    if (parameterValues.contains(arg)) {
                        return new ArrayList<String>();
                    }
                    val = args[i].substring(delimiterIdx + 1);
                    vals = Arrays.stream(val.split(String.valueOf(CommandsAPI.multiParameterDelimiter))).collect(Collectors.toSet());
                    CommandParameter parameter = tempParameters.get(arg);
                    List<String> relevantValues = new ArrayList<String>(parameter.relevantValues(callerId));
                    front = args[i].contains(String.valueOf(CommandsAPI.multiParameterDelimiter)) ? args[i].substring(0, args[i].lastIndexOf(CommandsAPI.multiParameterDelimiter)) + CommandsAPI.multiParameterDelimiter : arg + CommandsAPI.parameterDelimiter;
                    relevantValues = relevantValues.stream().filter(s -> !vals.contains(s)).map(s -> front + s).collect(Collectors.toList());
                    possibleResults.addAll(relevantValues);
                    for (String v : vals) {
                        Map<String, CommandParameter> subParams = parameter.subParams(v);
                        if (subParams == null) continue;
                        tempParameters.putAll(subParams);
                    }
                }
            } else {
                CommandParameter value;
                String key;
                for (Map.Entry<String, CommandParameter> entry : parameterLookup.entrySet()) {
                    String permission;
                    key = entry.getKey();
                    value = entry.getValue();
                    if (key == null || value == null || (permission = value.permission()) != null && !permissionCheckMethod.test(permission)) continue;
                    possibleResults.add(key + CommandsAPI.parameterDelimiter);
                }
                for (Map.Entry<String, CommandParameter> entry : tempParameters.entrySet()) {
                    String permission;
                    key = entry.getKey();
                    value = entry.getValue();
                    if (key == null || value == null || (permission = value.permission()) != null && !permissionCheckMethod.test(permission)) continue;
                    possibleResults.add(key + CommandsAPI.parameterDelimiter);
                }
                for (CommandsAPICommand command : this.getCommandLookup().values()) {
                    String permission = command.permission();
                    if (permission != null && !permissionCheckMethod.test(permission)) continue;
                    possibleResults.add(command.name());
                }
            }
        } else {
            String key;
            CommandsAPICommand nextCommand = this.getCommandLookup().get(args[i].toUpperCase());
            if (nextCommand != null) {
                return nextCommand.onTabComplete(callerId, permissionCheckMethod, args, i + 1, tempParameters);
            }
            for (Map.Entry<String, CommandParameter> entry : parameterLookup.entrySet()) {
                key = entry.getKey();
                CommandParameter value = entry.getValue();
                if (key == null || value == null) continue;
                String permission = value.permission();
                if (parameterValues.contains(key) || permission != null && !permissionCheckMethod.test(permission)) continue;
                possibleResults.add(key + CommandsAPI.parameterDelimiter);
            }
            for (Map.Entry<String, CommandParameter> entry : tempParameters.entrySet()) {
                key = entry.getKey();
                CommandParameter value = entry.getValue();
                if (key == null || value == null) continue;
                String permission = value.permission();
                if (parameterValues.contains(key) || permission != null && !permissionCheckMethod.test(permission)) continue;
                possibleResults.add(key + CommandsAPI.parameterDelimiter);
            }
            for (CommandsAPICommand command : this.getCommandLookup().values()) {
                String permission = command.permission();
                if (permission != null && !permissionCheckMethod.test(permission)) continue;
                possibleResults.add(command.name());
            }
        }
        possibleResults.add("help");
        if (args.length > 0) {
            return possibleResults.stream().filter(s -> s.startsWith(args[args.length - 1])).collect(Collectors.toList());
        }
        return possibleResults;
    }

    default public boolean onCommand(@NotNull UUID callerId, @NotNull Predicate<String> permissionCheckMethod, @NotNull Consumer<String> messageMethod, @NotNull String[] args) {
        return this.onCommand(callerId, permissionCheckMethod, messageMethod, args, 0, null);
    }

    @Override
    default public boolean onCommand(@NotNull UUID callerId, @NotNull Predicate<String> permissionCheckMethod, @NotNull Consumer<String> messageMethod, @NotNull String[] args, int i, @Nullable Map<String, CommandParameter> tempParameters) {
        if (tempParameters == null) {
            tempParameters = new HashMap<String, CommandParameter>();
        }
        if (!permissionCheckMethod.test(this.permission())) {
            return false;
        }
        HashMap<String, List<String>> parameterValues = new HashMap<String, List<String>>();
        while (i < args.length) {
            String arg = args[i];
            if (arg.endsWith(String.valueOf(CommandsAPI.parameterDelimiter))) {
                messageMethod.accept("no value given for " + arg);
            } else {
                String paramName;
                CommandParameter currentParameter;
                String[] argSplit = arg.split(String.valueOf(CommandsAPI.parameterDelimiter));
                if (argSplit.length < 2) {
                    if (arg.equalsIgnoreCase("help") && !this.getCommandLookup().containsKey("HELP")) {
                        this.help(callerId, permissionCheckMethod).forEach(messageMethod);
                        return true;
                    }
                    CommandsAPICommand subCommand = this.getCommandLookup().get(arg.toUpperCase());
                    if (subCommand == null) {
                        return true;
                    }
                    CompletableFuture<Boolean> cont = new CompletableFuture<Boolean>();
                    CommandExecutor commandExecutor = new CommandExecutor(this, callerId, parameterValues, subCommand, cont);
                    CommandsAPI.commandPipeline.add(commandExecutor);
                    if (!permissionCheckMethod.test(subCommand.permission())) {
                        return false;
                    }
                    int finalI = i + 1;
                    Map<String, CommandParameter> finalTempParameters = tempParameters;
                    cont.whenCompleteAsync((aBoolean, throwable) -> {
                        if (aBoolean.booleanValue()) {
                            subCommand.onCommand(callerId, permissionCheckMethod, messageMethod, args, finalI, finalTempParameters);
                        }
                    });
                    return true;
                }
                Map<String, CommandParameter> parameterLookup = this.getParameterLookup();
                CommandParameter commandParameter = currentParameter = parameterLookup.containsKey(paramName = argSplit[0].toLowerCase()) ? parameterLookup.get(paramName) : tempParameters.get(paramName);
                if (currentParameter == null) {
                    messageMethod.accept("bad parameter:" + argSplit[0]);
                } else {
                    String val = argSplit[1];
                    List vals = Arrays.stream(val.split(String.valueOf(CommandsAPI.multiParameterDelimiter))).filter(s -> {
                        Boolean pass = currentParameter.isRelevant.apply(callerId, (String)s);
                        if (!pass.booleanValue()) {
                            this.msgBadParameter(callerId, paramName, (String)s);
                        }
                        return pass;
                    }).collect(Collectors.toList());
                    if (vals.size() > 0) {
                        parameterValues.putIfAbsent(paramName, vals);
                    }
                }
            }
            ++i;
        }
        boolean res = this.onCommand(callerId, parameterValues, null);
        return res;
    }

    @Override
    default public List<String> help(UUID callerId, Predicate<String> permissionCheckMethod) {
        ArrayList<String> parents = new ArrayList<String>();
        for (CommandsAPICommand parent = this.parent(); parent != null; parent = parent.parent()) {
            parents.add(parent.name());
        }
        StringBuilder completeCommand = new StringBuilder();
        for (int i = parents.size() - 1; i > 0; --i) {
            completeCommand.append((String)parents.get(i)).append(" ");
        }
        ArrayList<String> possibleResults = new ArrayList<String>(2 + this.getParameterLookup().size() + this.getCommandLookup().size());
        possibleResults.add("Command: " + completeCommand + "\n    " + this.description());
        possibleResults.add("Subcommands: ");
        for (CommandsAPICommand commandsAPICommand : this.getCommandLookup().values()) {
            if (!permissionCheckMethod.test(commandsAPICommand.permission())) continue;
            possibleResults.add("  - /" + completeCommand + commandsAPICommand.name() + "\n    " + commandsAPICommand.description());
        }
        possibleResults.add("Parameters: ");
        for (Map.Entry entry : this.getParameterLookup().entrySet()) {
            if (!permissionCheckMethod.test(((CommandParameter)entry.getValue()).permission())) continue;
            possibleResults.add("  - " + (String)entry.getKey() + CommandsAPI.parameterDelimiter + "\n    " + ((CommandParameter)entry.getValue()).description());
        }
        return possibleResults;
    }
}

