/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.devintest.api.resources.imdb;

import com.devintest.api.core.ClientOptions;
import com.devintest.api.core.DevintestApiApiException;
import com.devintest.api.core.DevintestApiException;
import com.devintest.api.core.DevintestApiHttpResponse;
import com.devintest.api.core.MediaTypes;
import com.devintest.api.core.ObjectMappers;
import com.devintest.api.core.RequestOptions;
import com.devintest.api.resources.imdb.errors.MovieDoesNotExistError;
import com.devintest.api.resources.imdb.types.CreateMovieRequest;
import com.devintest.api.resources.imdb.types.Movie;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawImdbClient {
    protected final ClientOptions clientOptions;

    public RawImdbClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * Add a movie to the database
     */
    public DevintestApiHttpResponse<String> createMovie(CreateMovieRequest request) {
        return createMovie(request, null);
    }

    /**
     * Add a movie to the database
     */
    public DevintestApiHttpResponse<String> createMovie(CreateMovieRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("movies")
                .addPathSegments("create-movie")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new DevintestApiException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                return new DevintestApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), String.class), response);
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new DevintestApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new DevintestApiException("Network error executing HTTP request", e);
        }
    }

    /**
     * Retrieve a movie from the database based on the ID
     */
    public DevintestApiHttpResponse<Movie> getMovie(String id) {
        return getMovie(id, null);
    }

    /**
     * Retrieve a movie from the database based on the ID
     */
    public DevintestApiHttpResponse<Movie> getMovie(String id, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("movies")
                .addPathSegment(id)
                .build();
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                return new DevintestApiHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Movie.class), response);
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                if (response.code() == 404) {
                    throw new MovieDoesNotExistError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, String.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new DevintestApiApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new DevintestApiException("Network error executing HTTP request", e);
        }
    }
}
